/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.swing.CustomLayoutConstraints;
import net.wordrider.dialogs.LimitedPlainDocument;
import net.wordrider.dialogs.SaveSettingsDialog;
import net.wordrider.dialogs.settings.CheckBoxOption;
import net.wordrider.dialogs.settings.ComboBoxOption;
import net.wordrider.dialogs.settings.ComboModelItem;
import net.wordrider.dialogs.settings.DefaultOptionsGroup;
import net.wordrider.dialogs.settings.JTextFieldOption;
import net.wordrider.dialogs.settings.SettingsDialog;
import net.wordrider.dialogs.settings.SettingsPanel;
import net.wordrider.utilities.Swinger;

final class MiscSettingsPanel
extends SettingsPanel {
    public MiscSettingsPanel(SettingsDialog settingsDialog, String string) {
        super(settingsDialog, string);
    }

    protected final void init() {
        DefaultOptionsGroup defaultOptionsGroup = new DefaultOptionsGroup();
        CheckBoxOption checkBoxOption = new CheckBoxOption(this.manager, "settings.imageFormatDialog", "settings.imageFormatRemember", true, defaultOptionsGroup);
        CheckBoxOption checkBoxOption2 = new CheckBoxOption(this.manager, "settings.inputFormatDialog", "settings.inputFormatRemember", true, defaultOptionsGroup);
        CheckBoxOption checkBoxOption3 = new CheckBoxOption(this.manager, "settings.renameImage", "settings.renameImageDialog", false, defaultOptionsGroup);
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0, -2.0, -1.0}, new double[]{-2.0});
        tableLayout.setVGap(0);
        tableLayout.setHGap(4);
        JPanel jPanel = new JPanel(tableLayout);
        Object[] objectArray = new Object[]{new TitleStyle(0), new TitleStyle(1), new TitleStyle(2), new TitleStyle(3)};
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        defaultComboBoxModel.setSelectedItem(new TitleStyle(AppPrefs.getProperty("settings.frameTitleType", 0)));
        final ComboBoxOption comboBoxOption = new ComboBoxOption(this.manager, defaultComboBoxModel, defaultOptionsGroup){

            public void applyChange() {
                super.applyChange();
                AppPrefs.storeProperty("settings.frameTitleType", ((TitleStyle)this.getComponent().getSelectedItem()).getValue());
                MainApp.getInstance().getMainAppFrame().getManagerDirector().getTitleChanger().updateTitle();
            }
        };
        CheckBoxOption checkBoxOption4 = new CheckBoxOption(this.manager, "settings.checkFrameTitle", "settings.frameTitle", true, defaultOptionsGroup){

            public void itemStateChanged(ItemEvent itemEvent) {
                super.itemStateChanged(itemEvent);
                comboBoxOption.getComponent().setEnabled(this.getComponent().isSelected());
            }

            public void applyChange() {
                super.applyChange();
                MainApp.getInstance().getMainAppFrame().getManagerDirector().getTitleChanger().updateTitle();
            }
        };
        JLabel jLabel = Swinger.getLabel("settings.labelFrameTitle");
        jPanel.add((Component)checkBoxOption4.getComponent(), new CustomLayoutConstraints(0, 0));
        jPanel.add((Component)comboBoxOption.getComponent(), new CustomLayoutConstraints(1, 0));
        jPanel.add((Component)jLabel, new CustomLayoutConstraints(2, 0));
        this.setFrameComboEnabled(comboBoxOption);
        LimitedPlainDocument limitedPlainDocument = new LimitedPlainDocument(SaveSettingsDialog.regexpFolderPattern);
        LimitedPlainDocument limitedPlainDocument2 = new LimitedPlainDocument(SaveSettingsDialog.regexpFolderPattern);
        LimitedPlainDocument limitedPlainDocument3 = new LimitedPlainDocument(SaveSettingsDialog.regexpComment);
        JTextField jTextField = new JTextFieldOption(this.manager, limitedPlainDocument, "settings.defaultFolder", "main", defaultOptionsGroup).getComponent();
        JTextField jTextField2 = new JTextFieldOption(this.manager, limitedPlainDocument2, "settings.defaultVariable", "untitled", defaultOptionsGroup).getComponent();
        JTextField jTextField3 = new JTextFieldOption(this.manager, limitedPlainDocument3, "settings.defaultComment", "generated_by_Wordrider", defaultOptionsGroup).getComponent();
        Swinger.SelectAllOnFocusListener selectAllOnFocusListener = new Swinger.SelectAllOnFocusListener();
        jTextField.addFocusListener(selectAllOnFocusListener);
        jTextField2.addFocusListener(selectAllOnFocusListener);
        jTextField3.addFocusListener(selectAllOnFocusListener);
        JLabel jLabel2 = Swinger.getLabel("settings.input.folder");
        jLabel2.setLabelFor(jTextField);
        JLabel jLabel3 = Swinger.getLabel("settings.input.variable");
        jLabel3.setLabelFor(jTextField2);
        JLabel jLabel4 = Swinger.getLabel("settings.input.comment");
        jLabel4.setLabelFor(jTextField3);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(new EtchedBorder(1), Lng.getLabel("settings.defaultValuesTitle")), BorderFactory.createEmptyBorder(2, 4, 0, 4)));
        jTextField.setPreferredSize(new Dimension(80, jTextField.getPreferredSize().height));
        jTextField2.setPreferredSize(jTextField.getPreferredSize());
        jPanel2.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(3, 4, 4, 0), 0, 0));
        jPanel2.add((Component)jLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(4, 4, 4, 0), 0, 0));
        jPanel2.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 0.8, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        jPanel2.add((Component)jTextField2, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(4, 4, 4, 4), 0, 0));
        jPanel2.add((Component)jTextField3, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        jPanel2.add((Component)jLabel3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(4, 4, 4, 4), 0, 0));
        TableLayout tableLayout2 = new TableLayout(new double[]{-2.0, -2.0, -1.0}, new double[]{-2.0, -2.0});
        tableLayout2.setVGap(0);
        tableLayout2.setHGap(4);
        JPanel jPanel3 = new JPanel(tableLayout2);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(new EtchedBorder(1), Lng.getLabel("settings.notefolioImportTitle")), BorderFactory.createEmptyBorder(2, 4, 0, 4)));
        Object[] objectArray2 = new Object[]{new NoteSep(0), new NoteSep(1), new NoteSep(10)};
        DefaultComboBoxModel<Object> defaultComboBoxModel2 = new DefaultComboBoxModel<Object>(objectArray2);
        defaultComboBoxModel2.setSelectedItem(new NoteSep(AppPrefs.getProperty("settings.notefolioSeparator", 1)));
        ComboBoxOption comboBoxOption2 = new ComboBoxOption(this.manager, defaultComboBoxModel2, defaultOptionsGroup){

            public void applyChange() {
                super.applyChange();
                AppPrefs.storeProperty("settings.notefolioSeparator", ((NoteSep)this.getComponent().getSelectedItem()).getValue());
            }
        };
        JLabel jLabel5 = Swinger.getLabel("settings.notefolio.label");
        jLabel2.setLabelFor(comboBoxOption2.getComponent());
        CheckBoxOption checkBoxOption5 = new CheckBoxOption(this.manager, "settings.putBreakpoints", "settings.notefolioBreakpoint", true, defaultOptionsGroup);
        jPanel3.add((Component)jLabel5, new CustomLayoutConstraints(0, 0));
        jPanel3.add((Component)comboBoxOption2.getComponent(), new CustomLayoutConstraints(1, 0, 1, 1, 0, 1));
        jPanel3.add((Component)checkBoxOption5.getComponent(), new CustomLayoutConstraints(0, 1, 3, 1));
        TableLayout tableLayout3 = new TableLayout(new double[]{-1.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -1.0});
        tableLayout3.setVGap(2);
        this.setLayout(tableLayout3);
        this.add((Component)checkBoxOption2.getComponent(), new CustomLayoutConstraints(0, 0));
        this.add((Component)checkBoxOption.getComponent(), new CustomLayoutConstraints(0, 1));
        this.add((Component)checkBoxOption3.getComponent(), new CustomLayoutConstraints(0, 2));
        this.add((Component)jPanel, new CustomLayoutConstraints(0, 4));
        this.add((Component)jPanel2, new CustomLayoutConstraints(0, 5));
        this.add((Component)jPanel3, new CustomLayoutConstraints(0, 6));
    }

    private void setFrameComboEnabled(ComboBoxOption comboBoxOption) {
        comboBoxOption.getComponent().setEnabled(AppPrefs.getProperty("settings.frameTitle", true));
    }

    private static final class TitleStyle
    extends ComboModelItem {
        public TitleStyle(int n) {
            super(n);
        }

        String getLabelByValue(int n) {
            switch (n) {
                case 0: {
                    return Lng.getLabel("settings.frame.title");
                }
                case 1: {
                    return Lng.getLabel("settings.frame.variable");
                }
                case 2: {
                    return Lng.getLabel("settings.frame.foldervar");
                }
                case 3: {
                    return Lng.getLabel("settings.frame.filepath");
                }
            }
            assert (false);
            return "not found";
        }
    }

    private static final class NoteSep
    extends ComboModelItem {
        public NoteSep(int n) {
            super(n);
        }

        String getLabelByValue(int n) {
            switch (n) {
                case 0: {
                    return Lng.getLabel("settings.singleLine");
                }
                case 1: {
                    return Lng.getLabel("settings.doubleLine");
                }
                case 10: {
                    return Lng.getLabel("settings.emptyLine");
                }
            }
            assert (false);
            return "not found";
        }
    }
}

