/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Frame;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.managers.AreaChangeEvent;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.InstanceEvent;
import net.wordrider.core.managers.interfaces.IAreaChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.managers.interfaces.InstanceListener;

public class TitleManager
implements IAreaChangeListener,
InstanceListener {
    public static final int TITLE_FILENAME = 0;
    public static final int VARIABLE_NAME = 1;
    public static final int FOLDER_VARIABLE_NAME = 2;
    public static final int FILE_PATH = 3;
    private final Frame frame;
    private static final Logger logger = Logger.getLogger(TitleManager.class.getName());
    private static final String TITLE_FORMAT = "%s - [%s%s]";

    public TitleManager(Frame frame) {
        this.frame = frame;
    }

    public void areaActivated(AreaChangeEvent areaChangeEvent) {
        areaChangeEvent.getFileInstance().addInstanceListener(this);
        this.updateTitle(areaChangeEvent.getFileInstance());
    }

    public void areaDeactivated(AreaChangeEvent areaChangeEvent) {
        areaChangeEvent.getFileInstance().removeInstanceListener(this);
        if (((AreaManager)areaChangeEvent.getSource()).getOpenedInstanceCount() == 1) {
            this.setEmptyInfo();
        }
    }

    public void updateTitle() {
        if (!AppPrefs.getProperty("settings.frameTitle", true)) {
            this.setEmptyInfo();
        } else {
            this.updateTitle((IFileInstance)AreaManager.getInstance().getActiveInstance());
        }
    }

    public void instanceModifiedStatusChanged(InstanceEvent instanceEvent) {
        this.fileAssigned(instanceEvent);
    }

    public void fileAssigned(InstanceEvent instanceEvent) {
        this.updateTitle(instanceEvent.getInstance());
    }

    private void updateTitle(IFileInstance iFileInstance) {
        if (iFileInstance == null) {
            this.setEmptyInfo();
            return;
        }
        if (AppPrefs.getProperty("settings.frameTitle", true)) {
            String string;
            switch (AppPrefs.getProperty("settings.frameTitleType", 0)) {
                case 1: {
                    string = TitleManager.getVarName(iFileInstance);
                    break;
                }
                case 2: {
                    string = TitleManager.getFolderName(iFileInstance) + "/" + TitleManager.getVarName(iFileInstance);
                    break;
                }
                case 3: {
                    if (iFileInstance.hasAssignedFile()) {
                        string = iFileInstance.getFile().getPath();
                        break;
                    }
                    string = iFileInstance.getName();
                    break;
                }
                default: {
                    string = iFileInstance.getName();
                }
            }
            this.setTitle(String.format(TITLE_FORMAT, "WordRider 0.8", string, iFileInstance.isModified() ? "*" : ""));
        }
    }

    private static String getVarName(IFileInstance iFileInstance) {
        String string = iFileInstance.getFileInfo().getVarName();
        if (string.length() == 0) {
            string = AppPrefs.getProperty("settings.defaultVariable", "untitled");
        }
        return string;
    }

    private static String getFolderName(IFileInstance iFileInstance) {
        String string = iFileInstance.getFileInfo().getFolderName();
        if (string.length() == 0) {
            string = AppPrefs.getProperty("settings.defaultFolder", "main");
        }
        return string;
    }

    private void setEmptyInfo() {
        this.setTitle("WordRider 0.8");
    }

    private void setTitle(final String string) {
        if (!this.frame.getTitle().equals(string)) {
            logger.info("Updating title to " + string);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TitleManager.this.frame.setTitle(string);
                }
            });
        }
    }
}

