/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.views;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderStyles;
import net.wordrider.utilities.Swinger;

final class RiderParagraphView
extends ParagraphView {
    int childCount = 0;
    int shift = 0;
    private static int rowPosition = -1;
    private static Image breakPointImage = null;
    private static Image mathPointImage = null;
    private boolean isImage = false;
    private boolean isMath = false;

    public RiderParagraphView(Element element) {
        super(element);
        Image image;
        if (breakPointImage == null && (image = Swinger.getIconImage("breakpoint.gif")) != null) {
            breakPointImage = image;
        }
        if (mathPointImage == null && (image = Swinger.getIconImage("math.gif")) != null) {
            mathPointImage = image;
        }
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        if (this.isImage || RiderStyles.isImage(this.getElement().getElement(0))) {
            this.isImage = false;
            this.setJustification(1);
        }
        if (RiderStyles.isMath(this.getElement())) {
            this.isMath = true;
            this.setJustification(0);
        }
    }

    public final void paint(Graphics graphics, Shape shape) {
        this.childCount = this.getViewCount();
        super.paint(graphics, shape);
        Element element = this.getElement();
        int n = shape.getBounds().y + this.getTopInset();
        int n2 = n + this.getOffset(1, 0);
        int n3 = this.getSpan(1, 0);
        int n4 = n2 + n3 / 2;
        if (RiderStyles.isBookmark(element)) {
            if (breakPointImage != null) {
                graphics.drawImage(breakPointImage, 7, n4 - 7, null);
            } else {
                graphics.setColor(Color.RED);
                graphics.fillOval(6, n4 - 5, 10, 10);
            }
        } else if (RiderStyles.isMath(element)) {
            if (mathPointImage != null) {
                graphics.drawImage(mathPointImage, 4, n4 - 8, null);
            } else {
                graphics.setColor(Color.BLUE);
                graphics.fillOval(6, n4 - 5, 10, 10);
            }
        } else {
            graphics.setColor(Color.RED);
            graphics.fillOval(10, n4 - 2, 3, 3);
        }
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        int n5 = element.getStartOffset();
        int n6 = element.getEndOffset();
        int n7 = jTextComponent.getCaretPosition();
        if (n5 <= n7 && n7 <= n6) {
            for (int i = 0; i < this.childCount; ++i) {
                int n8 = this.shift + i + 1;
                if (n8 == rowPosition) continue;
                View view = this.getView(i);
                if (view.getStartOffset() <= n7 && n7 <= view.getEndOffset()) {
                    int n9 = rowPosition;
                    rowPosition = n8;
                    jTextComponent.firePropertyChange("linePosition", n9, rowPosition);
                }
                rowPosition = n8;
            }
        }
    }

    protected short getLeftInset() {
        if (!this.isMath) {
            int n;
            short s = super.getLeftInset();
            if (s > (n = ((RiderArea)this.getContainer()).getMaxMarginWidth())) {
                return (short)n;
            }
            return s;
        }
        return 0;
    }
}

