/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.files.ti68kformat;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.wordrider.files.InvalidDataTypeException;
import net.wordrider.files.ti68kformat.TIFileConstants;
import net.wordrider.files.ti68kformat.TIFileReader;
import net.wordrider.files.ti68kformat.TITextFileInfo;

public class TINoteFolioReader
extends TIFileReader {
    private String content = null;
    private int notesCount = 1;
    public static final char NOTE_SEPARATOR = '\f';
    private char contentChecksum;
    private static final byte[] END_OF_FILE = new byte[]{0, 70, 76, 73, 79, 0};

    public TINoteFolioReader() {
        this.fileInfo = new TITextFileInfo();
    }

    public final TITextFileInfo getTextFileInfo() {
        return (TITextFileInfo)this.fileInfo;
    }

    public byte getDataType() {
        return 28;
    }

    protected void readContent(DataInputStream dataInputStream) throws IOException, InvalidDataTypeException {
        int n;
        dataInputStream.skipBytes(9);
        this.notesCount = dataInputStream.readUnsignedByte();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        this.contentChecksum = '\u0000';
        while ((n = dataInputStream.readUnsignedByte()) != -1) {
            this.contentChecksum = (char)(this.contentChecksum + n);
            if (n == 0) {
                if (++n2 == this.notesCount) break;
                n = 12;
            }
            stringBuilder.append((char)n);
        }
        byte[] byArray = new byte[6];
        int n3 = dataInputStream.read(byArray);
        if (n3 != END_OF_FILE.length || !Arrays.equals(byArray, END_OF_FILE)) {
            throw new InvalidDataTypeException();
        }
        dataInputStream.skipBytes(1);
        this.content = stringBuilder.toString();
    }

    protected String[] getSupportedHeaders() {
        return TIFileConstants.SUPPORTED_FORMATS_TEXT;
    }

    protected void storeFileInformation(File file) {
    }

    protected char getCheckSum() {
        if (this.content == null) {
            return '\u0000';
        }
        int n = this.content.length() + 12;
        char c = this.contentChecksum;
        return (char)(c + 70 + 76 + 73 + 79 + 248 + this.notesCount + ((n & 0xFF) + (n >> 8 & 0xFF)));
    }

    public final String getContent() {
        return this.content;
    }
}

