/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.CopyAction;
import net.wordrider.area.actions.CutAction;
import net.wordrider.area.actions.DeleteAction;
import net.wordrider.area.actions.PasteAction;
import net.wordrider.area.actions.SelectAllAction;

public final class TextComponentContextMenuListener
implements AWTEventListener {
    public void eventDispatched(AWTEvent aWTEvent) {
        final MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        final Component component = SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        if (!(component instanceof JTextComponent)) {
            return;
        }
        if (component instanceof RiderArea) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextComponentContextMenuListener.this.showPopmenu(component, mouseEvent);
            }
        });
    }

    private void showPopmenu(Component component, MouseEvent mouseEvent) {
        JTextComponent jTextComponent = (JTextComponent)component;
        jTextComponent.grabFocus();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(CutAction.getInstance());
        jPopupMenu.add(CopyAction.getInstance());
        jPopupMenu.add(PasteAction.getInstance());
        jPopupMenu.add(new DeleteAction(jTextComponent));
        jPopupMenu.addSeparator();
        jPopupMenu.add(SelectAllAction.getInstance());
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), jTextComponent);
        jPopupMenu.show(jTextComponent, point.x, point.y);
    }
}

