/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import net.wordrider.area.ColorStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.CloseAllAction;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.PluginToolsManager;
import net.wordrider.utilities.LogUtils;

public final class ExitAction
extends CoreAction {
    private static final ExitAction INSTANCE = new ExitAction();
    private static final String CODE = "ExitAction";
    private static final Logger logger = Logger.getLogger(ExitAction.class.getName());

    private ExitAction() {
        super(CODE, KeyStroke.getKeyStroke(115, 8), "exit.gif");
    }

    public static ExitAction getInstance() {
        return INSTANCE;
    }

    private static void storeWindowPosition() {
        if (AppPrefs.getProperty("settings.position", false)) {
            JFrame jFrame = ExitAction.getMainFrame();
            AppPrefs.storeProperty("settings.positionMax", jFrame.getExtendedState() == 6);
            AppPrefs.storeProperty("settings.positionH", jFrame.getHeight());
            AppPrefs.storeProperty("settings.positionW", jFrame.getWidth());
            AppPrefs.storeProperty("settings.positionX", jFrame.getX());
            AppPrefs.storeProperty("settings.positionY", jFrame.getY());
        } else {
            AppPrefs.removeProperty("settings.positionH");
            AppPrefs.removeProperty("settings.positionW");
            AppPrefs.removeProperty("settings.positionX");
            AppPrefs.removeProperty("settings.positionMax");
            AppPrefs.removeProperty("settings.positionY");
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        if (CloseAllAction.closeAll()) {
            try {
                AreaManager.getInstance().getRecentFilesManager().storeRecentFiles();
                PluginToolsManager.getInstance().closeSoftAllInstances(false);
                ExitAction.storeWindowPosition();
                ColorStyles.storeColors();
                AppPrefs.store();
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
            System.exit(0);
        }
    }
}

