/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import net.wordrider.area.ScrollGestureRecognizer;
import net.wordrider.utilities.Swinger;

final class ScrollGlassPane
extends JComponent
implements ActionListener,
MouseInputListener,
SwingConstants {
    private static final Image img = Swinger.getIconImage("mouse.gif");
    private Component oldGlassPane = null;
    private Point location = null;
    private final Timer movingTimer;
    private Point mouseLocation;
    private final JViewport viewport;
    private final Rectangle imageRect;

    public ScrollGlassPane(Component component, JViewport jViewport, Point point) {
        this.oldGlassPane = component;
        this.viewport = jViewport;
        this.location = this.mouseLocation = point;
        this.setOpaque(false);
        ScrollGestureRecognizer.getInstance().stop();
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(8));
        this.addMouseMotionListener(this);
        this.imageRect = new Rectangle(point.x - 15, point.y - 15, img.getWidth(null), img.getHeight(null));
        this.movingTimer = new Timer(100, this);
        this.movingTimer.start();
    }

    protected final void paintComponent(Graphics graphics) {
        graphics.drawImage(img, this.location.x - 15, this.location.y - 15, this);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        int n = (this.mouseLocation.x - this.location.x) / 4;
        int n2 = (this.mouseLocation.y - this.location.y) / 4;
        Point point = this.viewport.getViewPosition();
        point.translate(n, n2);
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= this.viewport.getView().getWidth() - this.viewport.getWidth()) {
            point.x = this.viewport.getView().getWidth() - this.viewport.getWidth();
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= this.viewport.getView().getHeight() - this.viewport.getHeight()) {
            point.y = this.viewport.getView().getHeight() - this.viewport.getHeight();
        }
        this.viewport.setViewPosition(point);
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        this.movingTimer.stop();
        this.setVisible(false);
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        jRootPane.setGlassPane(this.oldGlassPane);
        ScrollGestureRecognizer.getInstance().start();
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        this.setVisible(false);
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        jRootPane.setGlassPane(this.oldGlassPane);
        ScrollGestureRecognizer.getInstance().start();
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        this.mouseLocation = mouseEvent.getPoint();
        if (this.imageRect.contains(this.mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.getCursor().getType() != 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
    }
}

