/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.event.ActionEvent;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;

public final class CloseAllUnmodifiedAction
extends CoreAction {
    private static final CloseAllUnmodifiedAction instance = new CloseAllUnmodifiedAction();
    private static final String CODE = "CloseAllUnmodifiedAction";

    private CloseAllUnmodifiedAction() {
        super(CODE, null, null);
    }

    public static CloseAllUnmodifiedAction getInstance() {
        return instance;
    }

    public boolean isEnabled() {
        AreaManager areaManager = AreaManager.getInstance();
        return areaManager.getModifiedInstances().size() != areaManager.getOpenedInstanceCount();
    }

    private static boolean closeAll() {
        AreaManager areaManager = AreaManager.getInstance();
        for (FileInstance fileInstance : areaManager.getOpenedInstances()) {
            if (fileInstance.isModified()) continue;
            areaManager.closeInstanceHard(fileInstance);
        }
        return true;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        CloseAllUnmodifiedAction.closeAll();
    }
}

