/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import net.wordrider.area.ScrollGlassPane;

final class ScrollGestureRecognizer
implements AWTEventListener {
    private static final ScrollGestureRecognizer instance = new ScrollGestureRecognizer();

    private ScrollGestureRecognizer() {
        this.start();
    }

    public static ScrollGestureRecognizer getInstance() {
        return instance;
    }

    final void start() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
    }

    final void stop() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    public final void eventDispatched(AWTEvent aWTEvent) {
        boolean bl;
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        boolean bl2 = bl = SwingUtilities.isMiddleMouseButton(mouseEvent) && mouseEvent.getID() == 501;
        if (!bl) {
            return;
        }
        JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, mouseEvent.getComponent());
        if (jViewport == null) {
            return;
        }
        JRootPane jRootPane = SwingUtilities.getRootPane(jViewport);
        if (jRootPane == null) {
            return;
        }
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), jRootPane.getGlassPane());
        ScrollGlassPane scrollGlassPane = new ScrollGlassPane(jRootPane.getGlassPane(), jViewport, point);
        jRootPane.setGlassPane(scrollGlassPane);
        jRootPane.setCursor(Cursor.getDefaultCursor());
        scrollGlassPane.setVisible(true);
    }
}

