/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import net.wordrider.core.Lng;
import net.wordrider.utilities.Swinger;

public class GraphicMenuItem
extends JLabel
implements MouseListener {
    private String titleText;
    private String text;
    private final Action action;
    private static final String ITEM_STYLE = Lng.getLabel("gmenu.section");
    private static final String ITEM_STYLE_OVER = Lng.getLabel("gmenu.sectionOver");
    private static final Border emptyBorder = BorderFactory.createEmptyBorder(8, 10, 8, 10);

    public GraphicMenuItem(String string, String string2, Icon icon, Action action) {
        this.titleText = string;
        this.text = string2;
        this.action = action;
        this.setIcon(icon);
        this.setFocusable(true);
        this.setText(this.updateText(false));
        this.setBorder(emptyBorder);
        this.setOpaque(false);
        this.setBackground(null);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(this);
    }

    private String updateText(boolean bl) {
        if (bl) {
            return String.format(ITEM_STYLE_OVER, this.titleText, this.text);
        }
        return String.format(ITEM_STYLE, this.titleText, this.text);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasFocus()) {
            Rectangle rectangle = this.getBounds();
            graphics.setColor(Color.BLACK);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.action.actionPerformed(new ActionEvent(this, 0, ""));
        mouseEvent.consume();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Swinger.inputFocus(this);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setText(this.updateText(true));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setText(this.updateText(false));
    }
}

