/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.IFileType;
import net.wordrider.core.actions.TextRiderProcess;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.dialogs.RiderFileFilter;
import net.wordrider.dialogs.SaveSettingsDialog;
import net.wordrider.files.ti68kformat.TIFileInfo;
import net.wordrider.files.ti68kformat.TIImageFileInfo;
import net.wordrider.files.ti68kformat.TIImageFileWriter;
import net.wordrider.files.ti68kformat.TITextFileInfo;
import net.wordrider.files.ti68kformat.TITextFileWriter;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SaveAsFileAction
extends CoreAction {
    private static final SaveAsFileAction instance = new SaveAsFileAction();
    private static final String CODE = "SaveAsFileAction";
    private static final String LASTFOLDER_KEY = "settings.lastOpenFolder";
    private static final Logger logger = Logger.getLogger(SaveAsFileAction.class.getName());

    public static SaveAsFileAction getInstance() {
        return instance;
    }

    private SaveAsFileAction() {
        super(CODE, KeyStroke.getKeyStroke(83, 3), "save_as.gif");
    }

    static boolean runSaveProcess(JFrame jFrame, File file, IFileInstance iFileInstance, boolean bl) {
        try {
            TextRiderProcess textRiderProcess = new TextRiderProcess();
            String string = textRiderProcess.getTxtRiderTextForDocument((StyledDocument)((JTextComponent)iFileInstance.getRiderArea()).getDocument(), iFileInstance.getFileInfo(), true);
            logger.info(string);
            TITextFileWriter tITextFileWriter = new TITextFileWriter();
            tITextFileWriter.setFileInfo(iFileInstance.getFileInfo());
            tITextFileWriter.setTextContent(string);
            tITextFileWriter.saveToFile(file);
            iFileInstance.setFile(file);
        }
        catch (BadLocationException badLocationException) {
            Swinger.showErrorDialog(jFrame, Lng.getLabel("message.error.Fwriting", badLocationException.getMessage()));
            LogUtils.processException(logger, badLocationException);
            return false;
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
            Swinger.showErrorDialog(jFrame, Lng.getLabel("message.error.saving", iOException.getMessage()));
            return false;
        }
        if (jFrame != null && bl && AppPrefs.getProperty("settings.infosave", true)) {
            Swinger.showInformationDialog(jFrame, Lng.getLabel("message.information.savedSuccess", file.getAbsolutePath()));
        }
        return true;
    }

    private static boolean runImageSaveProcess(JFrame jFrame, File file, Image image, TIFileInfo tIFileInfo) {
        try {
            TIImageFileWriter tIImageFileWriter = new TIImageFileWriter(image);
            tIImageFileWriter.setFileInfo(tIFileInfo);
            tIImageFileWriter.saveToFile(file);
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
            Swinger.showErrorDialog(jFrame, Lng.getLabel("message.error.saving", iOException.getMessage()));
            return false;
        }
        return true;
    }

    static TIFileInfo getSaveSettings(Frame frame, TIFileInfo tIFileInfo, int n) {
        SaveSettingsDialog saveSettingsDialog = new SaveSettingsDialog(frame, tIFileInfo, n);
        return saveSettingsDialog.getResult();
    }

    /*
     * WARNING - void declaration
     */
    private static File uniSaveProcess(Frame frame, List<FileFilter> list, FileFilter fileFilter, String string, String string2) {
        int n;
        void var9_12;
        File file;
        File file2 = new File(AppPrefs.getProperty(LASTFOLDER_KEY, ""));
        JFileChooser jFileChooser = new JFileChooser(file2);
        jFileChooser.setDialogTitle(Lng.getLabel("SaveAsFileAction.dialog.title"));
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        if (fileChooserUI instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)fileChooserUI).setFileName(string);
        }
        for (FileFilter object2 : list) {
            jFileChooser.addChoosableFileFilter(object2);
        }
        jFileChooser.setFileFilter(fileFilter);
        if (jFileChooser.showSaveDialog(frame) != 0) {
            return null;
        }
        FileFilter fileFilter2 = jFileChooser.getFileFilter();
        if (string2 != null) {
            AppPrefs.storeProperty(string2, list.indexOf(jFileChooser.getFileFilter()));
        }
        if ((file = jFileChooser.getSelectedFile()) == null) {
            return null;
        }
        if (fileFilter2 instanceof IFileType && Utils.getExtension(file) == null) {
            String string3 = ((IFileType)((Object)fileFilter2)).getExtension();
            File file3 = new File(file.getPath().concat(".").concat(string3));
        }
        if (var9_12.exists() && (n = Swinger.getChoice(frame, Lng.getLabel("message.confirm.overwrite"))) == 1) {
            return null;
        }
        AppPrefs.storeProperty(LASTFOLDER_KEY, var9_12.getAbsolutePath());
        return var9_12;
    }

    static boolean saveAsProcess(boolean bl) {
        File file;
        JFrame jFrame = SaveAsFileAction.getMainFrame();
        IFileInstance iFileInstance = (IFileInstance)AreaManager.getInstance().getActiveInstance();
        if (iFileInstance == null) {
            return false;
        }
        TITextFileInfo tITextFileInfo = (TITextFileInfo)SaveAsFileAction.getSaveSettings(jFrame, iFileInstance.getFileInfo(), 0);
        if (tITextFileInfo == null) {
            return false;
        }
        iFileInstance.setFileInfo(tITextFileInfo);
        List<FileFilter> list = SaveAsFileAction.getFileFilters();
        int n = list.size();
        int n2 = AppPrefs.getProperty("settings.savefilter", n - 1);
        if (n2 < 0 || n2 >= n - 1) {
            n2 = n - 1;
        }
        return (file = SaveAsFileAction.uniSaveProcess(jFrame, list, list.get(n2), tITextFileInfo.getVarName(), "settings.savefilter")) != null && SaveAsFileAction.runSaveProcess(jFrame, file, iFileInstance, bl);
    }

    public static File saveAsImageProcess(TIImageFileInfo tIImageFileInfo, Image image) {
        RiderFileFilter riderFileFilter;
        JFrame jFrame = SaveAsFileAction.getMainFrame();
        TIImageFileInfo tIImageFileInfo2 = (TIImageFileInfo)SaveAsFileAction.getSaveSettings(jFrame, tIImageFileInfo, 1);
        if (tIImageFileInfo2 == null) {
            return null;
        }
        tIImageFileInfo.setInsertIntoDocument(tIImageFileInfo2.isInsertIntoDocument());
        boolean bl = AppPrefs.getProperty("settings.ti92ImageFormat", false);
        ArrayList<FileFilter> arrayList = new ArrayList<FileFilter>(2);
        if (bl) {
            arrayList.add(new RiderFileFilter(new String[]{"92i"}, "picturedialog.ti92files"));
            riderFileFilter = new RiderFileFilter(new String[]{"9xi"}, "picturedialog.ti9xfiles");
            arrayList.add(riderFileFilter);
        } else {
            riderFileFilter = new RiderFileFilter(new String[]{"89i"}, "picturedialog.ti89files");
            arrayList.add(riderFileFilter);
        }
        File file = SaveAsFileAction.uniSaveProcess(jFrame, arrayList, riderFileFilter, tIImageFileInfo2.getVarName(), null);
        if (file != null && SaveAsFileAction.runImageSaveProcess(jFrame, file, image, tIImageFileInfo2)) {
            return file;
        }
        return null;
    }

    private static List<FileFilter> getFileFilters() {
        ArrayList<FileFilter> arrayList = new ArrayList<FileFilter>(2);
        arrayList.add(new RiderFileFilter(new String[]{"92t"}, "OpenFileAction.dialog.filter92"));
        arrayList.add(new RiderFileFilter(new String[]{"9xt"}, "OpenFileAction.dialog.filter9x"));
        arrayList.add(new RiderFileFilter(new String[]{"89t"}, "OpenFileAction.dialog.filter89"));
        return arrayList;
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        SaveAsFileAction.saveAsProcess(true);
    }
}

