/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import net.wordrider.area.RiderArea;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.AbstractFileProcessor;
import net.wordrider.core.actions.BatchNotefolioRead;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.files.ti68kformat.TINoteFolioReader;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

class NotefolioFileProcessor
extends AbstractFileProcessor {
    public NotefolioFileProcessor(File file) {
        super(file);
    }

    public boolean process() {
        super.process();
        AreaManager areaManager = AreaManager.getInstance();
        try {
            TINoteFolioReader tINoteFolioReader = new TINoteFolioReader();
            File file = this.getFile();
            tINoteFolioReader.openFromFile(file);
            FileInstance fileInstance = new FileInstance(null, tINoteFolioReader.getTextFileInfo());
            fileInstance.getFileInfo().setOutputFormat(AppPrefs.getProperty("settings.inputFormatHibview", true) ? 0 : 1);
            areaManager.openFileInstance(fileInstance);
            RiderArea riderArea = fileInstance.getRiderArea();
            riderArea.setCursor(Cursor.getPredefinedCursor(3));
            fileInstance.setModified(true);
            boolean bl = this.loadDocument(riderArea, new BatchNotefolioRead(fileInstance, tINoteFolioReader.getContent()));
            fileInstance.setModified(true);
            return bl;
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            Swinger.showErrorDialog(this.getMainFrame(), Lng.getLabel("message.error.reading", iOException.getMessage()));
            return false;
        }
        catch (Exception exception) {
            logger.warning(exception.getMessage());
            Swinger.showErrorDialog(this.getMainFrame(), exception.getMessage());
            return false;
        }
    }
}

