/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.text.Element;
import javax.swing.text.Style;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.actions.StyledAreaAction;

public final class RotateAligmentStyleAction
extends StyledAreaAction {
    private static final RotateAligmentStyleAction instance = new RotateAligmentStyleAction();
    private static final String CODE = "RotateAligmentStyleAction";

    private RotateAligmentStyleAction() {
        super(CODE, KeyStroke.getKeyStroke("F4"), null);
    }

    public static RotateAligmentStyleAction getInstance() {
        return instance;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        RiderArea riderArea = this.getRiderArea(actionEvent);
        Element element = riderArea.getStyledDocument().getParagraphElement(riderArea.getCaretPosition());
        if (!RiderStyles.isReadonlySection(element) && !RiderStyles.isMath(element)) {
            Style style;
            switch (RiderStyles.getAlignment(riderArea.getParagraphAttributes())) {
                case 0: {
                    style = RiderStyles.alignmentCenteredStyle;
                    break;
                }
                case 1: {
                    style = RiderStyles.alignmentRightStyle;
                    break;
                }
                default: {
                    style = RiderStyles.alignmentLeftStyle;
                }
            }
            this.setParagraphAttributes(riderArea, style, false);
        }
    }
}

