/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.Utilities;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.actions.TextAreaAction;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.MainAppFrame;
import net.wordrider.dialogs.ChooseFormatDialog;
import net.wordrider.dialogs.PictureDialog;
import net.wordrider.dialogs.RiderFileFilter;
import net.wordrider.dialogs.pictures.FilterDialog;
import net.wordrider.files.InvalidDataTypeException;
import net.wordrider.files.NotSupportedFileException;
import net.wordrider.files.ti68kformat.TIImageDecoder;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class InsertPictureAction
extends TextAreaAction {
    private static final InsertPictureAction instance = new InsertPictureAction();
    private static final String key = "lastPictureFolder";
    private static final Logger logger = Logger.getLogger(InsertPictureAction.class.getName());

    public static InsertPictureAction getInstance() {
        return instance;
    }

    private InsertPictureAction() {
        super("InsertPictureAction", KeyStroke.getKeyStroke(80, 2), "ins_pic_v2.gif");
    }

    private static boolean checkFileName(File file, TIImageDecoder tIImageDecoder) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.equals(tIImageDecoder.getFileInfo().getVarName());
    }

    private static void insertTI89ImageFile(Frame frame, RiderArea riderArea, File file) {
        int n = riderArea.getCaretPosition();
        if (riderArea.getSelectionStart() != riderArea.getSelectionEnd()) {
            riderArea.select(n, n);
        }
        try {
            int n2;
            boolean bl;
            boolean bl2 = bl = Utilities.getRowStart(riderArea, n) == n;
            if (!bl) {
                riderArea.getDocument().insertString(riderArea.getCaretPosition(), "\n", null);
                ++n;
            }
            TIImageDecoder tIImageDecoder = new TIImageDecoder();
            try {
                if (!tIImageDecoder.openFromFile(file)) {
                    Swinger.showWarningDialog(frame, Lng.getLabel("picture.crcerror"));
                }
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                logger.warning(invalidDataTypeException.getMessage());
                Swinger.showErrorDialog(frame, invalidDataTypeException.getMessage());
                return;
            }
            catch (NotSupportedFileException notSupportedFileException) {
                logger.warning(notSupportedFileException.getMessage());
                Swinger.showErrorDialog(frame, notSupportedFileException.getMessage());
                return;
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
                Swinger.showErrorDialog(frame, iOException.getMessage());
                return;
            }
            if (!InsertPictureAction.checkFileName(file, tIImageDecoder) && (n2 = Swinger.getChoice(frame, Lng.getLabel("picture.filenameerror"))) != 0) {
                return;
            }
            RiderDocument riderDocument = riderArea.getDoc();
            riderArea.makeGroupChange(true);
            Style style = riderDocument.getLogicalStyle(n);
            riderDocument.setLogicalStyle(n, RiderStyles.alignmentCenteredStyle);
            riderDocument.removeBookmark(riderArea.getDoc().getParagraphElement(n));
            riderDocument.insertPicture(n, Toolkit.getDefaultToolkit().createImage(tIImageDecoder));
            riderDocument.insertString(n + 1, "\n", null);
            riderDocument.setLogicalStyle(n + 2, style);
            riderArea.makeGroupChange(false);
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
        }
    }

    private static Image loadInputImage(MediaTracker mediaTracker, Image image) {
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        return image;
    }

    public static void insertImageFromFilter(final Frame frame, final RiderArea riderArea, final File file, final Image image) {
        ChooseFormatDialog chooseFormatDialog;
        boolean bl = AppPrefs.getProperty("settings.imageFormatRemember", true) ? (chooseFormatDialog = new ChooseFormatDialog(frame, 1)).getResult() == 0 : true;
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FilterDialog filterDialog = new FilterDialog(frame, file, image);
                    filterDialog.setVisible(true);
                    File file2 = filterDialog.getOutputFile();
                    if (file2 != null && filterDialog.getFileInfo().isInsertIntoDocument()) {
                        InsertPictureAction.insertTI89ImageFile(frame, riderArea, file2);
                    }
                }
            });
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        String string;
        RiderArea riderArea = this.getRiderArea(actionEvent);
        if (riderArea == null) {
            return;
        }
        File file = new File(AppPrefs.getProperty(key, ""));
        PictureDialog pictureDialog = file.exists() ? new PictureDialog(file) : new PictureDialog();
        MainAppFrame mainAppFrame = MainApp.getInstance().getMainAppFrame();
        pictureDialog.freeResources();
        if (pictureDialog.showInsertDialog(mainAppFrame) != 0) {
            return;
        }
        File file2 = pictureDialog.getSelectedFile();
        if (file2 == null) {
            return;
        }
        if (!file2.exists() && (string = Utils.getExtension(file2)) == null && !(file2 = new File(file2.getAbsolutePath() + "." + ((RiderFileFilter)pictureDialog.getFileFilter()).getExtension())).exists()) {
            Swinger.showErrorDialog(mainAppFrame, Lng.getLabel("message.error.FNF", pictureDialog.getSelectedFile()));
            return;
        }
        AppPrefs.storeProperty(key, file2.getAbsolutePath());
        string = Utils.getExtension(file2);
        if (string != null && Swinger.isImageExtension(string)) {
            InsertPictureAction.insertTI89ImageFile(mainAppFrame, riderArea, file2);
        } else {
            Image image = null;
            MediaTracker mediaTracker = new MediaTracker(mainAppFrame);
            try {
                image = InsertPictureAction.loadInputImage(mediaTracker, Swinger.loadPicture(file2));
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                logger.warning(invalidDataTypeException.getMessage());
                Swinger.showErrorDialog(mainAppFrame, invalidDataTypeException.getMessage());
            }
            catch (NotSupportedFileException notSupportedFileException) {
                logger.warning(notSupportedFileException.getMessage());
                Swinger.showErrorDialog(mainAppFrame, notSupportedFileException.getMessage());
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
                Swinger.showErrorDialog(mainAppFrame, iOException.getMessage());
            }
            if (image != null) {
                InsertPictureAction.insertImageFromFilter(mainAppFrame, riderArea, file2, image);
                image.flush();
            }
        }
    }
}

