/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.files.ti68kformat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import net.wordrider.files.ti68kformat.TIFileInfo;
import net.wordrider.files.ti68kformat.TIFileWriter;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Utils;

public final class TIImageUpdater {
    private final TIFileInfo fileInfo;
    private final File f;
    private static final Logger logger = Logger.getLogger(TIImageUpdater.class.getName());
    private static final int MIN_LENGHT = 85;

    public TIImageUpdater(TIFileInfo tIFileInfo, File file) {
        this.fileInfo = tIFileInfo;
        this.f = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File doUpdate(boolean bl) throws IOException, IllegalAccessException {
        if (!this.f.exists()) {
            throw new FileNotFoundException();
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.f, "rw");
            if (randomAccessFile.length() <= 85L) {
                throw new IllegalAccessException();
            }
            this.updateData(randomAccessFile);
            randomAccessFile.close();
            randomAccessFile = null;
            if (bl) {
                String string = Utils.getExtension(this.f);
                String string2 = Utils.addFileSeparator(this.f.getParent()) + this.fileInfo.getVarName() + "." + (string != null ? string : "");
                File file = new File(string2);
                this.f.renameTo(file);
                File file2 = file;
                return file2;
            }
            File file = this.f;
            return file;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
        }
    }

    private void updateData(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(10L);
        TIFileWriter.writeString(randomAccessFile, this.fileInfo.getFolderName(), 8);
        TIFileWriter.writeString(randomAccessFile, this.fileInfo.getComment(), 40);
        randomAccessFile.skipBytes(6);
        TIFileWriter.writeString(randomAccessFile, this.fileInfo.getVarName(), 8);
        randomAccessFile.skipBytes(1);
        randomAccessFile.writeByte(this.fileInfo.getStoreType());
    }
}

