/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.files.ti68kformat;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import net.wordrider.files.ti68kformat.TIFile;

public abstract class TIFileWriter
extends TIFile {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToFile(File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            if (!file.exists() && !file.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            filterOutputStream = new DataOutputStream(new FileOutputStream(file));
            this.writeHeader((DataOutputStream)filterOutputStream);
            this.writeContent((DataOutputStream)filterOutputStream);
            this.writeChecksum((DataOutputStream)filterOutputStream);
            boolean bl = true;
            return bl;
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public static void writeString(DataOutput dataOutput, String string, int n) throws IOException {
        byte[] byArray;
        int n2 = (byArray = new String(string.getBytes(), "ASCII").getBytes()).length;
        dataOutput.write(byArray, 0, n2 > n ? n : n2);
        if (n2 < n) {
            for (int i = n2; i < n; ++i) {
                dataOutput.writeByte(0);
            }
        }
    }

    protected abstract int getContentFileSize();

    protected abstract String getFileHeaderType();

    private void writeHeader(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes(this.getFileHeaderType());
        dataOutputStream.writeShort(256);
        TIFileWriter.writeString(dataOutputStream, this.fileInfo.getFolderName(), 8);
        TIFileWriter.writeString(dataOutputStream, this.fileInfo.getComment(), 40);
        dataOutputStream.writeShort(256);
        dataOutputStream.writeInt(0x52000000);
        TIFileWriter.writeString(dataOutputStream, this.fileInfo.getVarName(), 8);
        dataOutputStream.writeByte(this.getDataType());
        dataOutputStream.writeByte(this.fileInfo.getStoreType());
        dataOutputStream.writeShort(65280);
        int n = dataOutputStream.size() + this.getContentFileSize();
        dataOutputStream.writeByte(n & 0xFF);
        dataOutputStream.writeByte(n >> 8 & 0xFF);
        dataOutputStream.writeByte(n >> 24 & 0xFF);
        dataOutputStream.writeByte(n >> 16 & 0xFF);
        dataOutputStream.writeShort(42330);
        dataOutputStream.writeShort(0);
    }

    protected abstract byte getDataType();

    private void writeChecksum(DataOutputStream dataOutputStream) throws IOException {
        char c = this.getCheckSum();
        dataOutputStream.writeByte(c);
        dataOutputStream.writeByte(c >> 8);
    }

    protected abstract char getCheckSum();

    protected abstract void writeContent(DataOutputStream var1) throws IOException;
}

