/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Cursor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.MainAppFrame;
import net.wordrider.dialogs.LoadingDialog;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.SwingWorker;

public abstract class RiderSwingWorker
extends SwingWorker {
    private static final Logger logger = Logger.getLogger(RiderSwingWorker.class.getName());
    protected LoadingDialog dialogToClose = null;
    private final boolean showLoading;
    String errorMessage = "";
    private MainAppFrame frame = MainApp.getInstance().getMainAppFrame();

    public RiderSwingWorker(boolean bl) {
        if (bl) {
            this.dialogToClose = new LoadingDialog(this.frame);
        }
        this.showLoading = bl;
    }

    public final void init() {
        this.start();
        if (this.showLoading) {
            this.dialogToClose.setVisible(true);
        }
    }

    public void finished() {
        super.finished();
        if (this.showLoading) {
            this.dialogToClose.dispose();
        }
    }

    protected final void showInfoWhileLoading(String string) {
        if (this.showLoading) {
            this.dialogToClose.setStatusText(Lng.getLabel(string));
        }
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    protected void setWaitCursor(final boolean bl) {
        this.invokeAndWait(new Runnable(){

            public void run() {
                if (RiderSwingWorker.this.frame != null) {
                    Cursor cursor = Cursor.getPredefinedCursor(3);
                    if (!bl) {
                        cursor = null;
                    }
                    RiderSwingWorker.this.frame.setCursor(cursor);
                }
            }
        });
    }

    private void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogUtils.processException(logger, invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            LogUtils.processException(logger, interruptedException);
        }
    }
}

