/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core;

import java.awt.BorderLayout;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.ExitAction;
import net.wordrider.core.actions.OpenFileAction;
import net.wordrider.core.managers.ManagerDirector;
import net.wordrider.core.managers.PluginToolsManager;
import net.wordrider.core.swing.TextComponentContextMenuListener;
import net.wordrider.gui.LookAndFeels;
import net.wordrider.plugintools.BreakpointList;
import net.wordrider.plugintools.CharacterList;
import net.wordrider.plugintools.FindAll;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MainAppFrame
extends JFrame {
    private JPanel rootPanel;
    private ManagerDirector mainPanelManager;
    private CharacterList characterList = null;
    private static final Logger logger = Logger.getLogger(MainAppFrame.class.getName());

    public MainAppFrame() throws HeadlessException {
        int n;
        int n2;
        boolean bl;
        LookAndFeels.getInstance().loadLookAndFeelSettings();
        Image image = Swinger.getIconImage("011.png");
        if (image != null) {
            this.setIconImage(image);
        }
        if (AppPrefs.getProperty("settings.decorated", false)) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
            LookAndFeels.updateWindowUI(this);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        int n3 = displayMode.getWidth();
        int n4 = displayMode.getHeight();
        if (AppPrefs.getProperty("settings.position", false) && !AppPrefs.getProperty("settings.positionMax", false)) {
            bl = false;
            this.setLocation(AppPrefs.getProperty("settings.positionX", 0), AppPrefs.getProperty("settings.positionY", 0));
            n2 = AppPrefs.getProperty("settings.positionW", n3);
            n = AppPrefs.getProperty("settings.positionH", n4);
        } else {
            bl = true;
            n2 = n3;
            n = n4;
        }
        this.setSize(n2, n);
        this.setTitle("WordRider 0.8" + (logger.isLoggable(Level.INFO) ? " debug" : ""));
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getMainPanel());
        if (bl) {
            this.setExtendedState(6);
        }
    }

    @Override
    protected final JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainAppFrame.this.mainPanelManager.getStatusbarManager().specialKeyStatusChanged();
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(144, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(20, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }

    private CharacterList getCharacterList() {
        return this.characterList == null ? (this.characterList = new CharacterList()) : this.characterList;
    }

    public final void init(final Collection<String> collection) {
        String[] stringArray;
        this.getManagerDirector();
        boolean bl = false;
        boolean bl2 = false;
        if (collection != null) {
            bl = true;
            bl2 = true;
        } else if (AppPrefs.getProperty("settings.newfile", false)) {
            bl2 = true;
            this.mainPanelManager.getAreaManager().openFileInstance();
        }
        if (!bl2) {
            this.mainPanelManager.getDataDividerManager().setGraphicMenu();
        }
        PluginToolsManager pluginToolsManager = this.mainPanelManager.getPluginToolsManager();
        pluginToolsManager.addPluginTool(this.getCharacterList());
        BreakpointList breakpointList = new BreakpointList();
        pluginToolsManager.addPluginTool(breakpointList);
        pluginToolsManager.addPluginTool(new FindAll());
        if (bl) {
            pluginToolsManager.selectPluginTool(breakpointList);
        }
        this.mainPanelManager.getAreaManager().grabActiveFocus();
        this.setVisible(true);
        String[] stringArray2 = stringArray = new String[]{"FileChooser.lookInLabelText", "FileChooser.saveInLabelText", "FileChooser.fileNameLabelText", "FileChooser.filesOfTypeLabelMnemonic", "FileChooser.filesOfTypeLabelText", "FileChooser.upFolderToolTipText", "FileChooser.upFolderAccessibleName", "FileChooser.homeFolderToolTipText", "FileChooser.homeFolderAccessibleName", "FileChooser.newFolderToolTipText", "FileChooser.newFolderAccessibleName", "FileChooser.listViewButtonToolTipText", "FileChooser.listViewButtonAccessibleName", "FileChooser.detailsViewButtonToolTipText", "FileChooser.detailsViewButtonAccessibleName", "FileChooser.fileNameHeaderText", "FileChooser.fileSizeHeaderText", "FileChooser.fileTypeHeaderText", "FileChooser.fileDateHeaderText", "FileChooser.fileAttrHeaderText", "FileChooser.cancelButtonText", "FileChooser.cancelButtonToolTipText", "FileChooser.deleteFileButtonText", "FileChooser.filesLabelText", "FileChooser.foldersLabelText", "FileChooser.newFolderButtonText", "FileChooser.openButtonText", "FileChooser.openButtonToolTipText", "FileChooser.openDialogTitleText", "FileChooser.pathLabelText", "FileChooser.renameFileButtonText", "FileChooser.saveButtonText", "FileChooser.saveButtonToolTipText", "FileChooser.saveDialogTitleText", "ColorChooser.cancelText", "ColorChooser.hsbBlueText", "ColorChooser.hsbBrightnessText", "ColorChooser.hsbDisplayedMnemonicIndex", "ColorChooser.hsbGreenText", "ColorChooser.hsbHueText", "ColorChooser.hsbMnemonic", "ColorChooser.hsbNameText", "ColorChooser.hsbRedText", "ColorChooser.hsbSaturationText", "ColorChooser.okText", "ColorChooser.previewText", "ColorChooser.resetMnemonic", "ColorChooser.resetText", "ColorChooser.rgbBlueText", "ColorChooser.rgbDisplayedMnemonicIndex", "ColorChooser.rgbGreenText", "ColorChooser.rgbMnemonic", "ColorChooser.rgbNameText", "ColorChooser.rgbRedText", "ColorChooser.sampleText", "ColorChooser.swatchesDisplayedMnemonicIndex", "ColorChooser.swatchesMnemonic", "ColorChooser.swatchesNameText", "ColorChooser.swatchesRecentText"};
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = stringArray2[i];
            UIManager.put(string2, Lng.getLabel(string2));
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(new TextComponentContextMenuListener(), 16L);
        if (!RiderStyles.isCorrectFont()) {
            Swinger.showErrorDialog(this, Lng.getLabel("message.error.fontloadfailed", new Object[]{"Ti-92p.ttf", "Ti92Pluspc"}));
        }
        if (collection != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (String string : collection) {
                        OpenFileAction.open(new File(string));
                    }
                }
            });
        }
    }

    private JPanel getMainPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel();
            this.rootPanel.setLayout(new BorderLayout());
        }
        return this.rootPanel;
    }

    public final ManagerDirector getManagerDirector() {
        if (this.mainPanelManager == null) {
            this.mainPanelManager = new ManagerDirector(this, this.rootPanel);
        }
        return this.mainPanelManager;
    }

    @Override
    protected final void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            ExitAction.getInstance().actionPerformed(null);
        }
    }
}

