/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.interfaces.IFileInstance;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

/**
 * @author Vity
 */
public final class SaveFileAction extends CoreAction {
    private static final SaveFileAction instance = new SaveFileAction();
    private static final String CODE = "SaveFileAction";

    public static SaveFileAction getInstance() {
        return instance;
    }

    private SaveFileAction() {
        super(CODE, KeyStroke.getKeyStroke(KeyEvent.VK_S, InputEvent.CTRL_MASK), "save.gif");
    }

    public static boolean save(final boolean showInfoWindow) {
        final IFileInstance instance = AreaManager.getInstance().getActiveInstance();
        if (instance == null)
            return false;
        if (!instance.hasAssignedFile()) {
            //not saved yet
            return SaveAsFileAction.saveAsProcess(showInfoWindow);
            //modified
        } else
            return SaveAsFileAction.runSaveProcess(getMainFrame(), instance.getFile(), instance, showInfoWindow);

    }

    public final void actionPerformed(final ActionEvent e) {
        save(true);
    }

}
