/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.Lng;
import net.wordrider.gui.LaF;
import net.wordrider.gui.LookAndFeels;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;

/**
 * @author Vity
 */
final class ChangeLookAndFeelAction extends CoreAction {
    private final static String CODE = "ChangeLookAndFeelAction";
    private final LaF laf;
    private final static Logger logger = Logger.getLogger(ChangeLookAndFeelAction.class.getName());

    public ChangeLookAndFeelAction(final LaF laf) {
        super(CODE, laf.getName(), (int) '\0', null);
        this.laf = laf;
    }

    public final void actionPerformed(final ActionEvent e) {
        boolean succesful;
        try {
            succesful = LookAndFeels.getInstance().loadLookAndFeel(laf, true);
            LookAndFeels.getInstance().storeSelectedLaF(laf);

        } catch (Exception ex) {
            LogUtils.processException(logger, ex);
            succesful = false;
        }
        if (succesful)
            Swinger.showInformationDialog(getMainFrame(), Lng.getLabel("ChangeLookAndFeelAction.set"));
        else
            Swinger.showErrorDialog(getMainFrame(), Lng.getLabel("ChangeLookAndFeelAction.failed"));
    }
}
