/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import javax.swing.*;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

/**
 * @author Vity
 */
public final class InvertCaseAction extends TextConversionAction {
    private static final TextConversionAction instance = new InvertCaseAction();

    public static TextConversionAction getInstance() {
        return instance;
    }

    private InvertCaseAction() {
        super("InvertCaseAction", KeyStroke.getKeyStroke(KeyEvent.VK_F3, InputEvent.SHIFT_MASK), "ico_inv-case.gif");
    }

    protected String doStringConversion(final String text) {
        final char[] chars = text.toCharArray();
        final int length = chars.length;
        char c;
        for (int i = 0; i < length; ++i) {
            c = chars[i];
            if (Character.isLowerCase(c))
                chars[i] = Character.toUpperCase(c);
            else if (Character.isUpperCase(c))
                chars[i] = Character.toLowerCase(c);
        }
        return new String(chars);
    }


}
