/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.gui;

/**
 * @author Vity
 */

import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import java.awt.*;

final class WordRiderMetalTheme extends DefaultMetalTheme {
    private final ColorUIResource color = new ColorUIResource(0, 0, 0);
    private final FontUIResource font = new FontUIResource("Dialog", Font.PLAIN, 11);

    public WordRiderMetalTheme() {
        super();
    }

    public final ColorUIResource getControlTextColor() {
        return color;
    }

    public final ColorUIResource getMenuTextColor() {
        return color;
    }

    public final ColorUIResource getSystemTextColor() {
        return color;
    }

    public final ColorUIResource getUserTextColor() {
        return color;
    }

    public final FontUIResource getControlTextFont() {
        return font;
    }

    public final FontUIResource getMenuTextFont() {
        return font;
    }

    public final FontUIResource getSystemTextFont() {
        return font;
    }

    public final FontUIResource getUserTextFont() {
        return font;
    }

    public final FontUIResource getWindowTitleFont() {
        return font;
    }

}
