/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.views;

import javax.swing.*;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import java.awt.*;

/**
 * @author Vity
 */
final class RiderComponentView extends ComponentView {
    public final void paint(final Graphics g, final Shape a) {
        ((JComponent) getComponent()).putClientProperty("selected", RiderViewFactory.isInSelection((JTextComponent) getContainer(), getElement()));
        super.paint(g, a);    //call to super
    }

    public final float getAlignment(final int axis) {
        return 0.5F;//super.getAlignment(axis);    //call to super
    }

    public RiderComponentView(final Element elem) {
        super(elem);
    }
}
