/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderStyles;

import javax.swing.*;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public final class RotateMarginStyleAction extends StyledAreaAction {
    private static final RotateMarginStyleAction instance = new RotateMarginStyleAction();
    private final static String CODE = "RotateMarginStyleAction";

    private RotateMarginStyleAction() {
        super(CODE, KeyStroke.getKeyStroke("F3"), null);
    }

    public static RotateMarginStyleAction getInstance() {
        return instance;
    }

    public final void actionPerformed(final ActionEvent e) {
        super.actionPerformed(e);
        final RiderArea area = getRiderArea(e);
        if (area == null) return;
        final AttributeSet set;
        final Element paraElement = area.getStyledDocument().getParagraphElement(area.getCaretPosition());
        if (!RiderStyles.isReadonlySection(paraElement) && !RiderStyles.isMath(paraElement)) {
            switch (RiderStyles.getMargin(area.getParagraphAttributes())) {
                case RiderStyles.MARGIN_0:
                    set = RiderStyles.margin10Style;
                    break;
                case RiderStyles.MARGIN_10:
                    set = RiderStyles.margin20Style;
                    break;
                case RiderStyles.MARGIN_20:
                    set = RiderStyles.margin30Style;
                    break;
                default:
                    set = RiderStyles.alignmentLeftStyle;
                    break;
            }
            setParagraphAttributes(area, set, false);
        }
    }


}
