/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import net.wordrider.area.RiderArea;
import net.wordrider.utilities.LogUtils;

import javax.swing.*;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.logging.Logger;

/**
 * @author Vity
 */
public final class RedoAction extends TextAreaAction {
    private static final RedoAction instance = new RedoAction();
    private static final String CODE = "RedoAction";
    private final static Logger logger = Logger.getLogger(RedoAction.class.getName());
    public static RedoAction getInstance() {
        return instance;
    }

    private RedoAction() {
        super(CODE, KeyStroke.getKeyStroke(KeyEvent.VK_Z, InputEvent.CTRL_MASK | InputEvent.SHIFT_MASK), "redo.gif");
        setEnabled(false);
    }

    public final void actionPerformed(final ActionEvent e) {
        final RiderArea area = (RiderArea) getTextComponent(e);
        if (area != null) {
            try {
                area.setBusy(true);                
                area.getUndoManager().redo();
            } catch (CannotRedoException ex) {
                LogUtils.processException(logger, ex);
            } finally{
                area.setBusy(false);
            }
            updateRedoState(area);
            UndoAction.getInstance().updateUndoState(area);
        }
    }

    public final void updateRedoState(final JTextComponent component) {
        final RiderArea area = (RiderArea) component;
        if (area != null) {
            final UndoManager undoManager = area.getUndoManager();
            if (undoManager != null)
                setEnabled(undoManager.canRedo());
            //            if (undoManager.canRedo()) {
            //                setEnabled(true);
            //                putValue(Action.NAME, undoManager.getRedoPresentationName());
            //            } else {
            //                setEnabled(false);
            //                putValue(Action.NAME, "Redo");
            //            }
        } else {
            setEnabled(false);
            //            putValue(Action.NAME, "Redo");
        }
    }
}

