/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.utilities;

import java.io.File;
import java.util.logging.Logger;

/**
 * @author Vity
 */
public final class BrowserControl {
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";
    private final static Logger logger = Logger.getLogger(BrowserControl.class.getName());

    private BrowserControl() {
    }

    public static void showURL(final String url) {
        final boolean windows = Utils.isWindows();
        String cmd = "";
        try {
            if (windows) {
                cmd = WIN_PATH + " " + WIN_FLAG + " " + url;
                Runtime.getRuntime().exec(cmd);
            } else {
                cmd = UNIX_PATH + " " + UNIX_FLAG + "(" + url + ")";
                final Process p = Runtime.getRuntime().exec(cmd);
                final int exitCode = p.waitFor();
                if (exitCode != 0) {
                    cmd = UNIX_PATH + " " + url;
                    Runtime.getRuntime().exec(cmd);
                }
            }
        } catch (Exception e) {
            logger.warning("Couldn't invoke browser, command=" + cmd);
            LogUtils.processException(logger, e);
        }
    }

    public static void openPDF(final File file) {
        final boolean windows = Utils.isWindows();
        String cmd = "";
        try {
            if (windows) {
                cmd = "rundll32 url.dll,FileProtocolHandler " + file.getPath();
            } else {
                cmd = "acroread " + file.getPath();
            }
            Runtime.getRuntime().exec(cmd);
        } catch (Exception e) {
            logger.warning("Couldn't invoke browser, command=" + cmd);
            LogUtils.processException(logger, e);
        }
    }

    public static void showHomepage() {
        showURL(Consts.WEBURL);
    }
}