/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.files.ti68kformat;

/**
 * @author Vity
 */
public final class TITextFileInfo extends TIFileInfo {
    public static final int PICTURE_FOLDER_DONTCHANGE = 0;
    public static final int PICTURE_FOLDER_USELAST = 1;
    public static final int PICTURE_FOLDER_USEOWN = 2;
    public static final int PICTURE_DONTSAVE = 3;
    public static final int PICTURE_USESAMEASFORDOCUMENT = 4;

    public static final int OUTPUT_FORMAT_HIBVIEW = 0;
    public static final int OUTPUT_FORMAT_TXTRIDER = 1;

    private String pictureFolder = "";

    private int outputFormat = -1;

    private int pictureProcessingType = PICTURE_FOLDER_DONTCHANGE;

    public boolean isHibviewFormat() {
        return outputFormat == 0 || outputFormat == -1;
    }

    final public int getPictureProcessingType() {
        return pictureProcessingType;
    }

    public int getOutputFormat() {
        return outputFormat;
    }


    public final void setOutputFormat(final int outputFormat) {
        this.outputFormat = outputFormat;
    }

    final public void setPictureProcessingType(final int pictureProcessingType) {
        this.pictureProcessingType = pictureProcessingType;
    }

    final public String getPictureFolder() {
        return pictureFolder;
    }

    final public void setPictureFolder(final String pictureFolder) {
        this.pictureFolder = pictureFolder;
        pictureProcessingType = PICTURE_FOLDER_USEOWN;
    }

}
