/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.dialogs.pictures.filters;

import java.awt.*;

/**
 * @author Vity
 */
abstract class OrderedFilter extends DitherRaster {
    private final int[] pattern;
    private final int level;
    private final static int whiteRGB = Color.WHITE.getRGB();
    private final static int blackRGB = Color.BLACK.getRGB();
    //    protected final Color getColor(int x, int y)
//    {
//        return new Color(pixels[y * width + x]);
//    }

    public OrderedFilter(final int[] pattern, final int level) {
        this.pattern = pattern;
        this.level = level;
        initPattern();
    }

    private void initPattern() {
        final int patternSize = pattern.length;
        for (int i = 0; i < patternSize; i++)
            pattern[i] = (255 * pattern[i]) / patternSize;
    }

    protected void performEffect() {
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                final int index = y * width + x;
                final int pixelValue = pixels[index] & 0xff;
                pixels[index] = pixelValue != 255 && pattern[(y % level) * level + x % level] >= pixelValue ? blackRGB : whiteRGB;
            }
        }
    }

}