/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;

import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public final class CloseAllUnmodifiedAction extends CoreAction {
    private static final CloseAllUnmodifiedAction instance = new CloseAllUnmodifiedAction();
    private static final String CODE = "CloseAllUnmodifiedAction";

    private CloseAllUnmodifiedAction() {
        super(CODE, null, null);
    }


    public static CloseAllUnmodifiedAction getInstance() {
        return instance;
    }


    @Override
    public boolean isEnabled() {
        final AreaManager areaManager = AreaManager.getInstance();
        return areaManager.getModifiedInstances().size() != areaManager.getOpenedInstanceCount();
    }

    private static boolean closeAll() {
        final AreaManager areaManager = AreaManager.getInstance();
        for (FileInstance o : areaManager.getOpenedInstances()) {
            if (!o.isModified()) { //is not modified list
                areaManager.closeInstanceHard(o);
            }
        }
        return true;
    }

    public final void actionPerformed(final ActionEvent e) {
        closeAll();
    }
}
