/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.views;

import javax.swing.text.*;

/**
 * @author Vity
 */
public final class RiderViewFactory implements ViewFactory {
    public final View create(final Element elem) {
        final String kind = elem.getName();
        if (kind != null)
            if (kind.equals(AbstractDocument.ContentElementName)) {
                return new RiderLabelView(elem);
            } else if (kind.equals(AbstractDocument.ParagraphElementName)) {
                return new RiderParagraphView(elem);
            } else if (kind.equals(AbstractDocument.SectionElementName)) {
                return new RiderSectionView(elem);
            } else if (kind.equals(StyleConstants.ComponentElementName)) {
                return new RiderComponentView(elem);
            } else if (kind.equals(StyleConstants.IconElementName)) {
                return new RiderIconView(elem);
            }
        // default
        return new RiderLabelView(elem);
    }

    static boolean isInSelection(final JTextComponent textComponent, final Element el) {
        final int selStart = textComponent.getSelectionStart();
        final int selEnd = textComponent.getSelectionEnd();
        if (selStart != selEnd) {
            // Something is selected, does p0 - p1 fall in that range?
            final int pMin;
            final int pMax;
            final int p0 = el.getStartOffset();
            final int p1 = el.getEndOffset();
            if (selStart <= p0)
                pMin = p0;
            else
                pMin = Math.min(selStart, p1);
            if (selEnd >= p1)
                pMax = p1;
            else
                pMax = Math.max(selEnd, p0);
            // If pMin == pMax (also == p0), selection isn't in this
            // block.
            if (pMin != pMax)
                return true;

        }
        return false;
    }


}