/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import net.wordrider.area.RiderArea;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.utilities.Swinger;

import javax.swing.*;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
abstract class TextAreaAction extends TextAction {
    public TextAreaAction(final String actionCode, final KeyStroke keyStroke, final String smallIcon) {
        super(actionCode);
        putValue(Action.NAME, Lng.getLabel(actionCode));
        putValue(Action.SHORT_DESCRIPTION, Lng.getHint(actionCode));
        putValue(Action.MNEMONIC_KEY, new Integer(Lng.getMnemonic(actionCode)));
        putValue(Action.ACCELERATOR_KEY, keyStroke);
        if (smallIcon != null)
            putValue(Action.SMALL_ICON, Swinger.getIcon(smallIcon));
    }

    abstract public void actionPerformed(ActionEvent e);

    public final KeyStroke getKeyStroke() {
        return (KeyStroke) getValue(Action.ACCELERATOR_KEY);
    }

    static AreaManager getAreaManager() {
        return MainApp.getInstance().getMainAppFrame().getManagerDirector().getAreaManager();
    }


    final RiderArea getRiderArea(final ActionEvent e) {
        final JTextComponent c = getTextComponent(e);
        if (!(c instanceof RiderArea)) {
            final IFileInstance instance = getAreaManager().getActiveInstance();
            if (instance != null) {
                AreaManager.grabActiveFocus(instance);
                return (RiderArea) instance.getRiderArea();
            }
            return null;
        } else return (RiderArea) c;
    }

}
