/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public final class NextPrevWordAction extends WordAction {
    private final boolean select;
    private final int direction;

    public NextPrevWordAction(final String action, final boolean select, final int direction) {
        super(action);
        this.select = select;
        this.direction = direction;
    }

    public void actionPerformed(final ActionEvent evt) {
        super.actionPerformed(evt);
        caretPosition = getWordInDirection(direction);
        if (caretPosition != NO_WORD_AVAILABLE) {
            if (select)
                getTextArea().moveCaretPosition(caretPosition);
            else
                getTextArea().setCaretPosition(caretPosition);
        }
    }
}
