/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import net.wordrider.utilities.LogUtils;

import javax.swing.text.BadLocationException;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;

/**
 * @author Vity
 */
public final class DeleteWordAction extends WordAction {
    private final int direction;
    private final static Logger logger = Logger.getLogger(DeleteWordAction.class.getName());

    public DeleteWordAction(final int direction) {
        super("DeleteWordAction");
        this.direction = direction;
    }

    public final void actionPerformed(final ActionEvent e) {
        super.actionPerformed(e);
        int selStart = textArea.getSelectionStart();
        int selEnd = textArea.getSelectionEnd();
        if (selStart == selEnd) {
            selStart = caretPosition;
            caretPosition = getWordInDirection(direction);
            if (caretPosition != NO_WORD_AVAILABLE) {
                selEnd = caretPosition - selStart;
                if (selEnd < 0) {  //direction left
                    selEnd = Math.abs(selEnd);
                    selStart = caretPosition;
                }
            } else return;
        } else selEnd -= selStart;
        try {
            textArea.getDocument().remove(selStart, selEnd);
        } catch (BadLocationException ex) {
            logger.severe("caretPosition : " + caretPosition);
            LogUtils.processException(logger, ex);
        }
    }

}
