/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderStyles;

import javax.swing.*;
import javax.swing.text.Element;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

/**
 * @author Vity
 */
public final class ChangeMathStyleAction extends StyledAreaAction {
    private static final ChangeMathStyleAction instance = new ChangeMathStyleAction();
    private static final String CODE = "ChangeMathStyleAction";

    public static ChangeMathStyleAction getInstance() {
        return instance;
    }

    private ChangeMathStyleAction() {
        super(CODE, KeyStroke.getKeyStroke(KeyEvent.VK_M, InputEvent.CTRL_MASK), "math.gif");
    }

    public final void actionPerformed(final ActionEvent e) {
        super.actionPerformed(e);
        final RiderArea area = getRiderArea(e);
        if (area != null) {
            final Element paraElement = area.getStyledDocument().getParagraphElement(area.getCaretPosition());
            if (!RiderStyles.isReadonlySection(paraElement)) {
                area.getInputAttributes().removeAttributes(area.getInputAttributes());
                area.getInputAttributes().addAttributes(RiderStyles.normalStyle);
                area.getDoc().setPrettyPrint(paraElement);
            }
        }
    }


}
