/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.swing;

import info.clearthought.layout.TableLayoutConstraints;


/**
 * CustomLayoutConstraints binds components to their constraints.
 * @author Vity
 */

public class CustomLayoutConstraints extends TableLayoutConstraints {


    /**
     * Constructs an TableLayoutConstraints a set of constraints.
     * @param col column where the component is placed
     * @param row row where the component is placed
     */

    public CustomLayoutConstraints(int col, int row) {
        this(col, row, 1, 1, FULL, FULL); //hack
    }


    /**
     * Constructs an TableLayoutConstraints a set of constraints.
     * @param col1 column where upper-left cornor of the component is placed
     * @param row1 row where upper-left cornor of the component is placed
     * @param col2 column where lower-right cornor of the component is placed
     * @param row2 row where lower-right cornor of the component is placed
     */

    public CustomLayoutConstraints(int col1, int row1, int col2, int row2) {
        this(col1, row1, col2, row2, FULL, FULL);
    }


    /**
     * Constructs an TableLayoutConstraints a set of constraints.
     * @param col1   column where upper-left cornor of the component is placed
     * @param row1   row where upper-left cornor of the component is placed
     * @param col2   column where lower-right cornor of the component is placed
     * @param row2   row where lower-right cornor of the component is placed
     * @param hAlign horizontal justification of a component in a single cell
     * @param vAlign vertical justification of a component in a single cell
     */

    public CustomLayoutConstraints
            (int col1, int row1, int col2, int row2, int hAlign, int vAlign) {
        super(col1, row1, col1 + col2 - 1, row1 + row2 - 1, hAlign, vAlign);
    }
}
