/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.managers;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;

/**
 * @author Vity
 */
class VerticalTextIcon implements Icon, SwingConstants {
    private Font font = UIManager.getFont("TabbedPane.font");
    // private Font font = UIManager.getFont("Label.font");
    private FontMetrics fm = new JLabel().getFontMetrics(font);

    private final String text;
    private int width, height;
    private final boolean clockwize;
    private final Icon icon;

    public VerticalTextIcon(final String text, final Icon icon, final boolean clockwize) {
        this.text = text;
        width = fm.stringWidth(text) + 3 + icon.getIconWidth();
        height = Math.max(fm.getHeight(), icon.getIconHeight());
        this.clockwize = clockwize;
        this.icon = icon;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D) g;
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        AffineTransform oldTransform = g2.getTransform();

        g.setFont(font);
        g.setColor(Color.black);
        if (clockwize) {
            g2.translate(x + getIconWidth(), y);
            g2.rotate(Math.PI / 2);
        } else {
            g2.translate(x, y + getIconHeight());
            g2.rotate(-Math.PI / 2);
        }
        g.drawString(text, 3 + icon.getIconWidth(), fm.getLeading() + fm.getAscent());
        icon.paintIcon(c, g, 0, 2);
        g.setFont(oldFont);
        g.setColor(oldColor);
        g2.setTransform(oldTransform);
    }

    public int getIconWidth() {
        return height;
    }

    public int getIconHeight() {
        return width;
    }
}
