/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.AppPrefs;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.utilities.Consts;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.io.File;

/**
 * @author Vity
 */
public final class OpenSampleFileAction extends CoreAction {

    public OpenSampleFileAction() {
        super("OpenSampleFileAction", null, null);
    }

    public final void actionPerformed(final ActionEvent e) {
        final File sampleFile = new File(AppPrefs.getAppPath() + Consts.SAMPLE_FILE);
        if (sampleFile.exists() && sampleFile.isFile()) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    final AreaManager areaManager = AreaManager.getInstance();
                    if (OpenFileAction.open(sampleFile))
                        areaManager.grabActiveFocus();
                }
            });
        }
    }


}
