/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.managers.MenuManager;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public class OpenRecentsAction extends CoreAction {

    public OpenRecentsAction() {
        super("OpenRecentsAction", null, null);
    }

    public void actionPerformed(ActionEvent e) {
        final JComponent source = (JComponent) e.getSource();
        final MenuManager menuManager = getManagerDirector().getMenuManager();
        final JMenu jMenu = menuManager.getRecentsMenu();
        final JPopupMenu popup = new JPopupMenu();

        final JPopupMenu menuPopmenu = jMenu.getPopupMenu();
        final Component[] components = menuPopmenu.getComponents();
        for (Component component : components) {
            popup.add((JMenuItem) component);
        }
        getManagerDirector().getAreaManager().getRecentFilesManager().buildRecentFileMenu();
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                showPopup(popup, source);
              //  popup.removeAll();
//              for (Component component : components) {
//                    menuPopmenu.add((JMenuItem) component);
//                }
            }
        });
    }

    private void showPopup(JPopupMenu popup, JComponent source) {
        popup.show(source.getParent(), source.getX(), source.getY() + source.getHeight() / 2);
    }
}
