/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.Lng;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.interfaces.IFileInstance;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

/**
 * @author Vity
 */
public final class CloseActiveAction extends CoreAction {
    private static final CloseActiveAction instance = new CloseActiveAction();
    private static final String CODE = "CloseActiveAction";

    private CloseActiveAction() {
        super(CODE, KeyStroke.getKeyStroke(KeyEvent.VK_F4, InputEvent.CTRL_MASK), null);
    }


    public static CloseActiveAction getInstance() {
        return instance;
    }

    private static void closeActive() {
        //        IFileInstance instance = getInstance().getActiveInstance();
        //        if (instance != null) {
        //            if (instance.isModified()) {
        //               if (!SaveFileAction.getInstance().save(e, false)) return false;
        //            }
        //
        //        }
        //        return true;
        AreaManager.getInstance().closeActiveInstance();
    }

    public final void updateStatusName(final IFileInstance instance) {
        final String newName = (instance != null) ? Lng.getLabel(CODE + ".opened", instance.getName()) : Lng.getLabel(CODE);
        putValue(Action.NAME, newName);
    }

    public final void actionPerformed(final ActionEvent e) {
        closeActive();
    }
}
