/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderDocument;

import javax.swing.*;
import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public final class UpdateBreakpointAction extends StyledAreaAction {
    private final static UpdateBreakpointAction instance = new UpdateBreakpointAction();
    private final static String CODE = "UpdateBreakpointAction";


    public static UpdateBreakpointAction getInstance() {
        return instance;
    }

    private UpdateBreakpointAction() {
        super(CODE, KeyStroke.getKeyStroke("F7"), "bookmark.gif");
    }

    public final void toggleBookmark(final RiderDocument doc, final int position) {
        super.actionPerformed(null);
        doc.toggleBookmark(position);
    }

    public final void actionPerformed(final ActionEvent e) {
        final RiderArea area = getRiderArea(e);
        if (area != null)
            toggleBookmark(area.getDoc(), area.getCaretPosition());
    }
}
