/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import net.wordrider.area.RiderArea;
import net.wordrider.core.Lng;
import net.wordrider.utilities.Swinger;

import javax.swing.*;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import java.awt.*;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

/**
 * @author Vity
 */

/**
 */
public final class PasteAction extends DefaultEditorKit.PasteAction {
    private final static PasteAction instance = new PasteAction();
    private static final String code = "PasteAction";

    public static PasteAction getInstance() {
        return instance;
    }

    private PasteAction() {
        super();
        putValue(Action.NAME, Lng.getLabel(code));
        putValue(Action.SHORT_DESCRIPTION, Lng.getHint(code));
        putValue(Action.MNEMONIC_KEY, new Integer(Lng.getMnemonic(code)));
        putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_V, InputEvent.CTRL_MASK));
        putValue(Action.SMALL_ICON, Swinger.getIcon("paste.gif"));
    }

    public boolean isEnabled() {
        final JTextComponent comp = getFocusedComponent();
        if (comp != null) {
            if (comp.isEditable() && comp.isEnabled()) {
                final Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                return contents.isDataFlavorSupported(DataFlavor.stringFlavor) || (contents.isDataFlavorSupported(RiderArea.df) && comp instanceof RiderArea);
            } else
                return false;
        }
        return false;
    }

}
