/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.dialogs;

import java.util.regex.Pattern;

/**
 * @author Vity
 */
public final class LimitedPlainDocument extends javax.swing.text.PlainDocument {
    private final Pattern pattern;

    public LimitedPlainDocument(final String regexp) {
        pattern = Pattern.compile(regexp);
    }

    public LimitedPlainDocument(final Pattern pattern) {
        this.pattern = pattern;
    }

    public final void insertString(final int param, final String str, final javax.swing.text.AttributeSet attributeSet) throws javax.swing.text.BadLocationException {
        if (str != null && str.length() > 0) {
            if (!pattern.matcher(getText(0, getLength()) + str).matches()) {
                java.awt.Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        super.insertString(param, str, attributeSet);
    }

}
