/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.files.ti68kformat;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import net.wordrider.files.ti68kformat.TIFileConstants;
import net.wordrider.files.ti68kformat.TIFileReader;
import net.wordrider.files.ti68kformat.TITextFileInfo;

public class TITextFileReader
extends TIFileReader {
    private String content = null;
    private char contentChecksum;

    public TITextFileReader() {
        this.fileInfo = new TITextFileInfo();
    }

    public final TITextFileInfo getTextFileInfo() {
        return (TITextFileInfo)this.fileInfo;
    }

    protected void readContent(DataInputStream dataInputStream) throws IOException {
        int n;
        dataInputStream.skipBytes(8);
        StringBuilder stringBuilder = new StringBuilder();
        this.contentChecksum = '\u0000';
        while ((n = dataInputStream.readUnsignedByte()) != 0 && n != -1) {
            this.contentChecksum = (char)(this.contentChecksum + n);
            stringBuilder.append((char)n);
        }
        dataInputStream.skipBytes(1);
        this.content = stringBuilder.toString();
    }

    protected String[] getSupportedHeaders() {
        return TIFileConstants.SUPPORTED_FORMATS_TEXT;
    }

    public final String getContent() {
        return this.content;
    }

    public byte getDataType() {
        return 11;
    }

    protected void storeFileInformation(File file) {
    }

    protected final char getCheckSum() {
        if (this.content == null) {
            return '\u0000';
        }
        int n = this.content.length() + 4;
        char c = this.contentChecksum;
        return (char)(c + 224 + 1 + ((n & 0xFF) + (n >> 8 & 0xFF)));
    }
}

