/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.pictures.filters;

import java.awt.image.ColorModel;
import net.wordrider.dialogs.pictures.filters.EffectFilter;

public abstract class DitherRaster
extends EffectFilter {
    final int[] quantize = new int[256];
    int threshold = 128;

    public final void setDimensions(int n, int n2) {
        super.setDimensions(n, n2);
        this.init();
    }

    public final void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n2 * this.width + n;
        int n8 = this.width - n3;
        while (n4 > 0) {
            int n9;
            for (n9 = 0; n9 < n3; ++n9) {
                this.pixels[n7++] = DitherRaster.getGrayColor(colorModel.getRGB(byArray[n5 + n9] & 0xFF));
            }
            for (n9 = 0; n9 < n8; ++n9) {
                this.pixels[n7++] = 255;
            }
            n5 += n6;
            --n4;
        }
    }

    public final void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n2 * this.width + n;
        int n8 = this.width - n3;
        while (n4 > 0) {
            int n9;
            for (n9 = 0; n9 < n3; ++n9) {
                this.pixels[n7++] = DitherRaster.getGrayColor(colorModel.getRGB(nArray[n5 + n9]));
            }
            for (n9 = 0; n9 < n8; ++n9) {
                this.pixels[n7++] = 255;
            }
            n5 += n6;
            --n4;
        }
    }

    private static int getGrayColor(int n) {
        return (((n & 0xFF0000) >> 16) + ((n & 0xFF00) >> 8) + (n & 0xFF)) / 3 & 0xFF;
    }

    void init() {
        this.setQuantLevels(2);
    }

    void setQuantLevels(int n) {
        this.threshold = (510 + n) / (2 * n);
        for (int i = 0; i < 256; ++i) {
            this.quantize[i] = Math.round(255L * Math.round((double)(i * (n - 1)) / 255.0) / (long)(n - 1));
        }
    }

    int getNoiseyPixel(int n, int n2, int n3) {
        return 0;
    }

    protected void performEffect() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n = this.getNoiseyPixel(j, i, this.pixels[i * this.width + j]);
                this.setPixel(j, i, n);
            }
        }
    }

    void quantize() {
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pixels[n++] = this.pixels[n] > this.threshold ? -1 : -16777216;
            }
        }
    }
}

