/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.pictures;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.image.VolatileImage;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import net.wordrider.utilities.Swinger;

final class PicturePanel
extends JComponent {
    private Image img = null;
    private static final int DX = 1;
    private static final int DY = 1;
    private boolean lcdScreen = false;
    private Image lcdImageScreen = null;
    private VolatileImage buffer = null;
    private static final Logger logger = Logger.getLogger(PicturePanel.class.getName());

    public PicturePanel() {
        this.setBackground(Color.lightGray);
        this.setPreferredSize(new Dimension(50, 50));
        this.setBorder(BorderFactory.createLineBorder(SystemColor.controlText, 1));
    }

    private void renderOffscreen(boolean bl) {
        do {
            Dimension dimension = this.getPreferredSize();
            if (bl || this.buffer == null || this.buffer.validate(this.getGraphicsConfiguration()) == 2) {
                this.buffer = this.createVolatileImage(dimension.width - 2, dimension.height - 2);
                if (this.buffer == null) {
                    logger.info("Renderoffscreen null");
                    return;
                }
            }
            Graphics2D graphics2D = this.buffer.createGraphics();
            if (this.lcdScreen && this.lcdImageScreen != null) {
                graphics2D.drawImage(this.lcdImageScreen, 0, 0, null);
                graphics2D.drawImage(this.img, 0, 0, null);
            } else {
                graphics2D.setColor(Color.LIGHT_GRAY);
                graphics2D.fillRect(0, 0, dimension.width - 2, dimension.height - 2);
                if (this.img != null) {
                    graphics2D.drawImage(this.img, 0, 0, Color.YELLOW, null);
                }
            }
            graphics2D.dispose();
        } while (this.buffer.contentsLost());
    }

    public final void paintComponent(Graphics graphics) {
        if (this.isVisible()) {
            do {
                if (this.buffer == null) {
                    this.renderOffscreen(true);
                } else {
                    int n = this.buffer.validate(this.getGraphicsConfiguration());
                    if (n == 1) {
                        this.renderOffscreen(false);
                    } else if (n == 2) {
                        this.renderOffscreen(true);
                    }
                }
                graphics.drawImage(this.buffer, 1, 1, this);
            } while (this.buffer.contentsLost());
        }
    }

    public final Image getImg() {
        return this.img;
    }

    private void updateContent() {
        this.renderOffscreen(this.buffer == null);
        this.repaint();
    }

    public final void setLCDBackground(boolean bl, boolean bl2) {
        this.lcdScreen = bl;
        if (bl && this.lcdImageScreen == null) {
            this.lcdImageScreen = Swinger.getIconImage(bl2 ? "lcdscrn2.jpg" : "lcdscrn.png");
            this.updateContent();
        }
    }

    public final void setImg(Image image) {
        this.img = image;
        if (image != null) {
            this.updateContent();
        }
    }
}

