/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.AligmentCenterAction;
import net.wordrider.area.actions.AligmentLeftAction;
import net.wordrider.area.actions.AligmentRightAction;
import net.wordrider.area.actions.CapitalizeAction;
import net.wordrider.area.actions.ChangeConjugateStyleAction;
import net.wordrider.area.actions.ChangeDottedStyleAction;
import net.wordrider.area.actions.ChangeExponentStyleAction;
import net.wordrider.area.actions.ChangeFontSizeStyle1Action;
import net.wordrider.area.actions.ChangeFontSizeStyle2Action;
import net.wordrider.area.actions.ChangeFontSizeStyle3Action;
import net.wordrider.area.actions.ChangeInvertStyleAction;
import net.wordrider.area.actions.ChangeMathStyleAction;
import net.wordrider.area.actions.ChangeStrikedStyleAction;
import net.wordrider.area.actions.ChangeSubscriptStyleAction;
import net.wordrider.area.actions.ChangeUnderlineStyleAction;
import net.wordrider.area.actions.ChangeVectorStyleAction;
import net.wordrider.area.actions.ChangeWordWrapStyleAction;
import net.wordrider.area.actions.CopyAction;
import net.wordrider.area.actions.CutAction;
import net.wordrider.area.actions.InsertFromClipboardAction;
import net.wordrider.area.actions.InsertPictureAction;
import net.wordrider.area.actions.InsertSeparatorDoubleAction;
import net.wordrider.area.actions.InsertSeparatorSingleAction;
import net.wordrider.area.actions.InvertCaseAction;
import net.wordrider.area.actions.Margin10Action;
import net.wordrider.area.actions.Margin20Action;
import net.wordrider.area.actions.Margin30Action;
import net.wordrider.area.actions.MarginXAction;
import net.wordrider.area.actions.PasteAction;
import net.wordrider.area.actions.RedoAction;
import net.wordrider.area.actions.SelectAllAction;
import net.wordrider.area.actions.ShowFindReplaceDialogAction;
import net.wordrider.area.actions.TextToLowerCaseAction;
import net.wordrider.area.actions.TextToUpperCaseAction;
import net.wordrider.area.actions.TrimTrailingSpacesAction;
import net.wordrider.area.actions.UndoAction;
import net.wordrider.area.actions.UpdateBreakpointAction;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.ChangeImagePropertiesAction;
import net.wordrider.core.actions.ChangeLanguageAction;
import net.wordrider.core.actions.CheckForNewVersion;
import net.wordrider.core.actions.CloseActiveAction;
import net.wordrider.core.actions.CloseAllAction;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.CreateNewFileAction;
import net.wordrider.core.actions.ExitAction;
import net.wordrider.core.actions.OnlineDocumentationAction;
import net.wordrider.core.actions.OpenFileAction;
import net.wordrider.core.actions.OpenKeymapAction;
import net.wordrider.core.actions.OpenRecentFileAction;
import net.wordrider.core.actions.SaveAsFileAction;
import net.wordrider.core.actions.SaveFileAction;
import net.wordrider.core.actions.SendToCalcAction;
import net.wordrider.core.actions.ShowAboutAction;
import net.wordrider.core.actions.ShowUserSettings;
import net.wordrider.core.actions.Toggle89ViewAreaAction;
import net.wordrider.core.actions.Toggle92ViewAreaAction;
import net.wordrider.core.actions.ToggleFullViewAreaAction;
import net.wordrider.core.actions.ToggleStatusBarAction;
import net.wordrider.core.actions.ToggleToolbarAction;
import net.wordrider.core.actions.VisitHomepageAction;
import net.wordrider.core.managers.AreaChangeEvent;
import net.wordrider.core.managers.ManagerDirector;
import net.wordrider.core.managers.SupportedLanguage;
import net.wordrider.core.managers.interfaces.IAreaChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.dialogs.JButtonGroup;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MenuManager
implements IAreaChangeListener {
    private final JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu insertMenu;
    private JMenu formatMenu;
    private JMenu paragraphMenu;
    private JMenu viewMenu;
    private JMenu wordRiderMenu;
    private JMenu widthViewMenu;
    private JMenu recentMenu;
    private JMenu functionsMenu;
    private JRadioButtonMenuItem fullViewItem;
    private JRadioButtonMenuItem ti89ViewItem;
    private JRadioButtonMenuItem ti92ViewItem;
    private static final String LANG_NONAME_ICON = "blank.gif";
    private JMenuItem insertFromClipboardMenu;

    public MenuManager(ManagerDirector managerDirector) {
        managerDirector.getMainFrame().setJMenuBar(this.menuBar);
        this.selectedAreaChanged(false, null);
        this.menuBar.add(this.getFileMenu());
        this.menuBar.add(this.getEditMenu());
        this.menuBar.add(this.getFormatMenu());
        this.menuBar.add(this.getParagraphMenu());
        this.menuBar.add(this.getInsertMenu());
        this.menuBar.add(this.getViewMenu());
        this.menuBar.add(this.getWordRiderMenu());
    }

    private static JMenu initMenu(String string) {
        JMenu jMenu = new JMenu(Lng.getLabel("menu." + string));
        jMenu.setMnemonic(Lng.getMnemonic("menu." + string));
        return jMenu;
    }

    private Component getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = MenuManager.initMenu("view");
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            CoreAction coreAction = ToggleToolbarAction.getInstance(jCheckBoxMenuItem);
            jCheckBoxMenuItem.setAction(coreAction);
            this.viewMenu.add(jCheckBoxMenuItem);
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
            coreAction = ToggleStatusBarAction.getInstance(jCheckBoxMenuItem2);
            jCheckBoxMenuItem2.setAction(coreAction);
            this.viewMenu.add(jCheckBoxMenuItem2);
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getWidthViewMenu());
        }
        return this.viewMenu;
    }

    private JMenu getWidthViewMenu() {
        if (this.widthViewMenu != null) {
            return this.widthViewMenu;
        }
        this.widthViewMenu = MenuManager.initMenu("view.emulation");
        JButtonGroup jButtonGroup = new JButtonGroup();
        this.fullViewItem = new JRadioButtonMenuItem(ToggleFullViewAreaAction.getInstance());
        jButtonGroup.add(this.fullViewItem);
        this.ti89ViewItem = new JRadioButtonMenuItem(Toggle89ViewAreaAction.getInstance());
        jButtonGroup.add(this.ti89ViewItem);
        this.ti92ViewItem = new JRadioButtonMenuItem(Toggle92ViewAreaAction.getInstance());
        jButtonGroup.add(this.ti92ViewItem);
        this.fullViewItem.setSelected(true);
        this.widthViewMenu.add(this.fullViewItem);
        this.widthViewMenu.add(this.ti89ViewItem);
        this.widthViewMenu.add(this.ti92ViewItem);
        return this.widthViewMenu;
    }

    private JMenu getFunctionsFormatMenu() {
        if (this.functionsMenu != null) {
            return this.functionsMenu;
        }
        this.functionsMenu = MenuManager.initMenu("format.functions");
        this.functionsMenu.add(new JMenuItem(TrimTrailingSpacesAction.getInstance()));
        this.functionsMenu.addSeparator();
        this.functionsMenu.add(new JMenuItem(TextToUpperCaseAction.getInstance()));
        this.functionsMenu.add(new JMenuItem(TextToLowerCaseAction.getInstance()));
        this.functionsMenu.add(new JMenuItem(CapitalizeAction.getInstance()));
        this.functionsMenu.add(new JMenuItem(InvertCaseAction.getInstance()));
        return this.functionsMenu;
    }

    private Component getWordRiderMenu() {
        if (this.wordRiderMenu == null) {
            this.wordRiderMenu = MenuManager.initMenu("wordrider");
            JMenu jMenu = MenuManager.initMenu("ChangeLanguageAction");
            this.wordRiderMenu.add(jMenu);
            MenuManager.initLanguageMenu(jMenu);
            jMenu.setMnemonic(Lng.getMnemonic("ChangeLanguageAction"));
            this.wordRiderMenu.addSeparator();
            this.wordRiderMenu.add(new JMenuItem(OnlineDocumentationAction.getInstance()));
            this.wordRiderMenu.add(new JMenuItem(OpenKeymapAction.getInstance()));
            this.wordRiderMenu.addSeparator();
            this.wordRiderMenu.add(new JMenuItem(CheckForNewVersion.getInstance()));
            this.wordRiderMenu.add(new JMenuItem(VisitHomepageAction.getInstance()));
            this.wordRiderMenu.addSeparator();
            this.wordRiderMenu.add(new JMenuItem(ShowAboutAction.getInstance()));
        }
        return this.wordRiderMenu;
    }

    private static void initLanguageMenu(JMenu jMenu) {
        jMenu.setIcon(Swinger.getIcon(LANG_NONAME_ICON));
        String string = Lng.getSelectedLanguageCode();
        JButtonGroup jButtonGroup = new JButtonGroup();
        Iterator<SupportedLanguage> iterator = Lng.getSupportedLanguages().iterator();
        while (iterator.hasNext()) {
            SupportedLanguage supportedLanguage;
            SupportedLanguage supportedLanguage2 = supportedLanguage = iterator.next();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ChangeLanguageAction(supportedLanguage2));
            jButtonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(string.equals(supportedLanguage2.getLanguageCode()));
        }
    }

    private Component getParagraphMenu() {
        if (this.paragraphMenu == null) {
            this.paragraphMenu = MenuManager.initMenu("paragraph");
            this.paragraphMenu.add(new JMenuItem(AligmentLeftAction.getInstance()));
            this.paragraphMenu.add(new JMenuItem(AligmentRightAction.getInstance()));
            this.paragraphMenu.add(new JMenuItem(AligmentCenterAction.getInstance()));
            this.paragraphMenu.addSeparator();
            this.paragraphMenu.add(new JMenuItem(Margin10Action.getInstance()));
            this.paragraphMenu.add(new JMenuItem(Margin20Action.getInstance()));
            this.paragraphMenu.add(new JMenuItem(Margin30Action.getInstance()));
            this.paragraphMenu.add(new JMenuItem(MarginXAction.getInstance()));
            this.paragraphMenu.addSeparator();
            this.paragraphMenu.add(new JMenuItem(ChangeMathStyleAction.getInstance()));
        }
        return this.paragraphMenu;
    }

    private Component getFormatMenu() {
        if (this.formatMenu == null) {
            this.formatMenu = MenuManager.initMenu("format");
            this.formatMenu.add(new JMenuItem(ChangeFontSizeStyle1Action.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeFontSizeStyle2Action.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeFontSizeStyle3Action.getInstance()));
            this.formatMenu.addSeparator();
            this.formatMenu.add(new JMenuItem(ChangeExponentStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeSubscriptStyleAction.getInstance()));
            this.formatMenu.addSeparator();
            this.formatMenu.add(new JMenuItem(ChangeUnderlineStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeDottedStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeStrikedStyleAction.getInstance()));
            this.formatMenu.addSeparator();
            this.formatMenu.add(new JMenuItem(ChangeInvertStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeVectorStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeConjugateStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeWordWrapStyleAction.getInstance()));
            this.formatMenu.addSeparator();
            this.formatMenu.add(this.getFunctionsFormatMenu());
        }
        return this.formatMenu;
    }

    private Component getInsertMenu() {
        if (this.insertMenu == null) {
            this.insertMenu = MenuManager.initMenu("insert");
            this.insertMenu.addMenuListener(new SelectedMenuListener());
            this.insertMenu.add(new JMenuItem(InsertPictureAction.getInstance()));
            this.insertFromClipboardMenu = new JMenuItem(InsertFromClipboardAction.getInstance());
            this.insertMenu.add(this.insertFromClipboardMenu);
            this.insertMenu.addSeparator();
            this.insertMenu.add(new JMenuItem(InsertSeparatorSingleAction.getInstance()));
            this.insertMenu.add(new JMenuItem(InsertSeparatorDoubleAction.getInstance()));
            this.insertMenu.addSeparator();
            this.insertMenu.add(new JMenuItem(UpdateBreakpointAction.getInstance()));
        }
        return this.insertMenu;
    }

    private Component getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = MenuManager.initMenu("file");
            this.fileMenu.add(new JMenuItem(CreateNewFileAction.getInstance()));
            this.fileMenu.add(new JMenuItem(OpenFileAction.getInstance()));
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(SaveFileAction.getInstance()));
            this.fileMenu.add(new JMenuItem(SaveAsFileAction.getInstance()));
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(CloseActiveAction.getInstance()));
            this.fileMenu.add(new JMenuItem(CloseAllAction.getInstance()));
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(SendToCalcAction.getInstance()));
            this.fileMenu.addSeparator();
            this.recentMenu = MenuManager.initMenu("file.recentFiles");
            this.fileMenu.add(this.recentMenu);
            this.recentMenu.setEnabled(false);
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(ExitAction.getInstance()));
        }
        return this.fileMenu;
    }

    private Component getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = MenuManager.initMenu("edit");
            this.editMenu.addMenuListener(new EditMenuListener());
            this.editMenu.add(new JMenuItem(UndoAction.getInstance()));
            this.editMenu.add(new JMenuItem(RedoAction.getInstance()));
            this.editMenu.add(new JSeparator());
            this.editMenu.add(new JMenuItem(CutAction.getInstance()));
            this.editMenu.add(new JMenuItem(CopyAction.getInstance()));
            this.editMenu.add(new JMenuItem(PasteAction.getInstance()));
            this.editMenu.add(new JMenuItem(SelectAllAction.getInstance()));
            this.editMenu.addSeparator();
            this.editMenu.add(new JMenuItem(ShowFindReplaceDialogAction.getInstance()));
            this.editMenu.addSeparator();
            this.editMenu.add(new JMenuItem(ChangeImagePropertiesAction.getInstance()));
            this.editMenu.addSeparator();
            this.editMenu.add(new JMenuItem(ShowUserSettings.getInstance()));
        }
        return this.editMenu;
    }

    public JMenu getRecentsMenu() {
        return this.recentMenu;
    }

    @Override
    public void areaActivated(AreaChangeEvent areaChangeEvent) {
        this.selectedAreaChanged(true, areaChangeEvent.getFileInstance());
    }

    @Override
    public void areaDeactivated(AreaChangeEvent areaChangeEvent) {
        this.selectedAreaChanged(false, areaChangeEvent.getFileInstance());
    }

    private void selectedAreaChanged(boolean bl, IFileInstance iFileInstance) {
        RiderArea riderArea = bl ? (RiderArea)iFileInstance.getRiderArea() : null;
        RedoAction.getInstance().updateRedoState(riderArea);
        UndoAction.getInstance().updateUndoState(riderArea);
        ChangeFontSizeStyle1Action.getInstance().setEnabled(bl);
        ChangeFontSizeStyle2Action.getInstance().setEnabled(bl);
        ChangeFontSizeStyle3Action.getInstance().setEnabled(bl);
        AligmentLeftAction.getInstance().setEnabled(bl);
        AligmentCenterAction.getInstance().setEnabled(bl);
        AligmentRightAction.getInstance().setEnabled(bl);
        Margin10Action.getInstance().setEnabled(bl);
        Margin20Action.getInstance().setEnabled(bl);
        Margin30Action.getInstance().setEnabled(bl);
        ChangeInvertStyleAction.getInstance().setEnabled(bl);
        ChangeVectorStyleAction.getInstance().setEnabled(bl);
        ChangeWordWrapStyleAction.getInstance().setEnabled(bl);
        ChangeExponentStyleAction.getInstance().setEnabled(bl);
        ChangeUnderlineStyleAction.getInstance().setEnabled(bl);
        ChangeDottedStyleAction.getInstance().setEnabled(bl);
        ChangeStrikedStyleAction.getInstance().setEnabled(bl);
        UpdateBreakpointAction.getInstance().setEnabled(bl);
        InsertPictureAction.getInstance().setEnabled(bl);
        InsertSeparatorDoubleAction.getInstance().setEnabled(bl);
        InsertSeparatorSingleAction.getInstance().setEnabled(bl);
        ChangeMathStyleAction.getInstance().setEnabled(bl);
        MarginXAction.getInstance().setEnabled(bl);
        ChangeConjugateStyleAction.getInstance().setEnabled(bl);
        ChangeSubscriptStyleAction.getInstance().setEnabled(bl);
        ChangeImagePropertiesAction.getInstance().setEnabled(bl);
        if (riderArea != null) {
            boolean bl2 = riderArea.getSelectionStart() != riderArea.getSelectionEnd();
            CopyAction.getInstance().setEnabled(bl2 && riderArea.isEditable());
            CutAction.getInstance().setEnabled(bl2 && riderArea.isEditable());
            PasteAction.getInstance().setEnabled(riderArea.isEditable());
            switch (riderArea.getViewBorder()) {
                case 0: {
                    this.fullViewItem.setSelected(true);
                    break;
                }
                case 1: {
                    this.ti89ViewItem.setSelected(true);
                    break;
                }
                case 2: {
                    this.ti92ViewItem.setSelected(true);
                    break;
                }
                default: {
                    this.fullViewItem.setSelected(true);
                    break;
                }
            }
        } else {
            CopyAction.getInstance().setEnabled(bl);
            CutAction.getInstance().setEnabled(bl);
            CopyAction.getInstance().setEnabled(bl);
            PasteAction.getInstance().setEnabled(bl);
        }
        this.getWidthViewMenu().setEnabled(bl);
        SelectAllAction.getInstance().setEnabled(bl);
        ShowFindReplaceDialogAction.getInstance().setEnabled(bl);
        SaveFileAction.getInstance().setEnabled(bl && riderArea != null && iFileInstance.isModified());
        SaveAsFileAction.getInstance().setEnabled(bl);
        SendToCalcAction.getInstance().setEnabled(bl);
        CloseActiveAction.getInstance().setEnabled(bl);
        CloseActiveAction.getInstance().updateStatusName(iFileInstance);
        CloseAllAction.getInstance().setEnabled(bl);
        TrimTrailingSpacesAction.getInstance().setEnabled(bl);
        TextToUpperCaseAction.getInstance().setEnabled(bl);
        TextToLowerCaseAction.getInstance().setEnabled(bl);
        CapitalizeAction.getInstance().setEnabled(bl);
        InvertCaseAction.getInstance().setEnabled(bl);
        this.getFunctionsFormatMenu().setEnabled(bl);
    }

    public void updateRecentMenu(Collection<File> collection) {
        this.recentMenu.removeAll();
        int n = 0;
        for (File file : collection) {
            this.recentMenu.add(new JMenuItem(new OpenRecentFileAction(file, MenuManager.getMnemonicByPosition(n++))));
        }
        this.recentMenu.setEnabled(!collection.isEmpty());
    }

    private static char getMnemonicByPosition(int n) {
        return (char)(n > 9 ? 65 + n - 10 : 48 + n);
    }

    private static final class EditMenuListener
    implements MenuListener {
        private EditMenuListener() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            ChangeImagePropertiesAction.getInstance().updateEnabled();
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }
    }

    private final class SelectedMenuListener
    implements MenuListener {
        private SelectedMenuListener() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MenuManager.this.insertFromClipboardMenu.setEnabled(InsertFromClipboardAction.getInstance().isFlavourSupported());
                }
            });
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }
    }
}

