/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.gui.LaF;
import net.wordrider.gui.LookAndFeels;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

final class ChangeLookAndFeelAction
extends CoreAction {
    private static final String CODE = "ChangeLookAndFeelAction";
    private final LaF laf;
    private static final Logger logger = Logger.getLogger(ChangeLookAndFeelAction.class.getName());

    public ChangeLookAndFeelAction(LaF laF) {
        super(CODE, laF.getName(), 0, null);
        this.laf = laF;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        try {
            bl = LookAndFeels.getInstance().loadLookAndFeel(this.laf, true);
            LookAndFeels.getInstance().storeSelectedLaF(this.laf);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            bl = false;
        }
        if (bl) {
            Swinger.showInformationDialog(ChangeLookAndFeelAction.getMainFrame(), Lng.getLabel("ChangeLookAndFeelAction.set"));
        } else {
            Swinger.showErrorDialog(ChangeLookAndFeelAction.getMainFrame(), Lng.getLabel("ChangeLookAndFeelAction.failed"));
        }
    }
}

