/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import net.wordrider.area.actions.WordAction;
import net.wordrider.utilities.LogUtils;

public final class DeleteWordAction
extends WordAction {
    private final int direction;
    private static final Logger logger = Logger.getLogger(DeleteWordAction.class.getName());

    public DeleteWordAction(int n) {
        super("DeleteWordAction");
        this.direction = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        int n = this.textArea.getSelectionStart();
        int n2 = this.textArea.getSelectionEnd();
        if (n == n2) {
            n = this.caretPosition;
            this.caretPosition = this.getWordInDirection(this.direction);
            if (this.caretPosition == -100) return;
            n2 = this.caretPosition - n;
            if (n2 < 0) {
                n2 = Math.abs(n2);
                n = this.caretPosition;
            }
        } else {
            n2 -= n;
        }
        try {
            this.textArea.getDocument().remove(n, n2);
            return;
        }
        catch (BadLocationException badLocationException) {
            logger.severe("caretPosition : " + this.caretPosition);
            LogUtils.processException(logger, badLocationException);
        }
    }
}

