/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.wordrider.dialogs.settings.IOptionGroup;
import net.wordrider.dialogs.settings.IOptionable;
import net.wordrider.dialogs.settings.OptionsGroupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpinnerOption
implements IOptionable<JSpinner>,
ChangeListener {
    private final Object initValue;
    private Object applyedValue;
    private Object defaultValue = 10;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private final JSpinner spinner;

    public SpinnerOption(OptionsGroupManager optionsGroupManager, SpinnerModel spinnerModel, IOptionGroup iOptionGroup) {
        this.spinner = new JSpinner(spinnerModel);
        this.initValue = this.applyedValue = this.spinner.getValue();
        this.group = iOptionGroup;
        this.spinner.setValue(this.initValue);
        this.optionsGroupManager = optionsGroupManager;
        this.spinner.addChangeListener(this);
    }

    private void updateValue() {
        this.wasChanged = !this.applyedValue.equals(this.spinner.getValue());
        this.optionsGroupManager.makeChange(this);
    }

    @Override
    public final void stateChanged(ChangeEvent changeEvent) {
        this.updateValue();
    }

    public final void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    @Override
    public final void setDefault() {
        this.spinner.setValue(this.defaultValue);
    }

    @Override
    public final void restorePrevious() {
        this.spinner.setValue(this.initValue);
    }

    @Override
    public final boolean wasChanged() {
        return this.wasChanged;
    }

    @Override
    public void applyChange() {
        this.wasChanged = false;
        this.applyedValue = this.spinner.getValue();
    }

    public JSpinner getComponent() {
        return this.spinner;
    }

    @Override
    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }
}

