/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.TextAreaAction;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.utilities.Swinger;

abstract class StyledAreaAction
extends StyledEditorKit.StyledTextAction {
    public StyledAreaAction(String string, KeyStroke keyStroke, String string2) {
        super(string);
        this.putValue("Name", Lng.getLabel(string));
        this.putValue("ShortDescription", Lng.getHint(string));
        this.putValue("MnemonicKey", new Integer(Lng.getMnemonic(string)));
        this.putValue("AcceleratorKey", keyStroke);
        if (string2 != null) {
            this.putValue("SmallIcon", Swinger.getIcon(string2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        StyledAreaAction.updateStatus();
    }

    static void updateStatus() {
        MainApp.getInstance().getMainAppFrame().getManagerDirector().getToolbarManager().updateToolbar();
    }

    final RiderArea getRiderArea(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        if (!(jTextComponent instanceof RiderArea)) {
            IFileInstance iFileInstance = (IFileInstance)TextAreaAction.getAreaManager().getActiveInstance();
            if (iFileInstance != null) {
                AreaManager.grabActiveFocus(iFileInstance);
                return (RiderArea)iFileInstance.getRiderArea();
            }
            return null;
        }
        return (RiderArea)jTextComponent;
    }
}

